/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.paging;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.constants.CodeConstants;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Urls;

public class PageResult<E>
implements SignConstants,
CodeConstants {
    private String conditionEncoding = "UTF-8";
    private int total;
    private int pageSize;
    private int pageNo;
    private int totalPages;
    private List<E> records;
    private MapSS conditionMap;
    private boolean hasFirst = false;
    private boolean hasPrevious = false;
    private boolean hasNext = false;
    private boolean hasLast = false;

    PageResult(int total, int pageNo, int pageSize, List<E> records) {
        if (pageNo < 1) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        this.conditionMap = new HashMapSS(7);
        this.total = total;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.totalPages = (total - 1) / pageSize + 1;
        if (pageNo > 1) {
            this.hasFirst = true;
            this.hasPrevious = true;
        }
        if (pageNo < this.totalPages) {
            this.hasNext = true;
            this.hasLast = true;
        }
        this.records = records == null ? new ArrayList() : records;
    }

    PageResult(boolean hasNext, int pageNo, int pageSize, List<E> records) {
        if (pageNo < 1) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 10;
        }
        this.conditionMap = new HashMapSS(7);
        this.total = -1;
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.totalPages = -1;
        this.hasFirst = false;
        this.hasLast = false;
        if (pageNo > 1) {
            this.hasPrevious = true;
        }
        this.hasNext = hasNext;
        this.records = records == null ? new ArrayList() : records;
    }

    public String toString() {
        StringBuilder strb = new StringBuilder("PageResult:{");
        if (this.total == -1) {
            strb.append("hasNext:").append(this.hasNext).append(",");
        } else {
            strb.append("total:").append(this.total).append(",").append("totalPage:").append(this.totalPages).append(",");
        }
        strb.append("pageNo:").append(this.pageNo).append(",").append("pageSize:").append(this.pageSize).append(",").append("size:").append(this.size()).append(",").append("\r\n").append("[").append("\r\n");
        int i = 0;
        while (i < this.records.size()) {
            strb.append(this.records.get(i)).append("\r\n");
            ++i;
        }
        return strb.append("]").append("\r\n").append("}").toString();
    }

    public String getConditionEncoding() {
        return this.conditionEncoding;
    }

    public void setConditionEncoding(String coditionEncoding) {
        this.conditionEncoding = coditionEncoding;
    }

    public Map<String, String> getConditionMap() {
        return this.conditionMap.instance();
    }

    public void addCondition(String key, String value) {
        if ("page".equalsIgnoreCase(key) || "pageNo".equalsIgnoreCase(key) || value == null) {
            return;
        }
        this.conditionMap.put(key, Strings.trim(value));
    }

    public void addConditionMap(Map<String, String> condMap) {
        for (Map.Entry<String, String> entry : condMap.entrySet()) {
            if ("page".equalsIgnoreCase(entry.getKey()) || "pageNo".equalsIgnoreCase(entry.getKey()) || entry.getValue() == null) continue;
            this.conditionMap.put(entry.getKey(), Strings.trim(entry.getValue()));
        }
    }

    public String getConditionUrl() {
        if (this.conditionMap.isEmpty()) {
            return "";
        }
        StringBuilder strb = new StringBuilder("?");
        for (Map.Entry<String, String> entry : this.conditionMap.entrySet()) {
            String key = entry.getKey();
            String value = Urls.encode(entry.getValue(), this.conditionEncoding);
            strb.append(key).append("=").append(value).append("&");
        }
        strb.setLength(strb.length() - 1);
        return strb.toString();
    }

    public int total() {
        return this.total;
    }

    public List<E> list() {
        return this.records;
    }

    public int size() {
        return this.records.size();
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public int totalPages() {
        return this.totalPages;
    }

    public int pageNo() {
        return this.pageNo;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public boolean hasFirst() {
        return this.hasFirst;
    }

    public boolean hasPrevious() {
        return this.hasPrevious;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public boolean hasLast() {
        return this.hasLast;
    }

    public boolean hasLSegment(int segmentSize) {
        return (this.pageNo - 1) / segmentSize > 0;
    }

    public boolean hasRSegment(int segmentSize) {
        return (this.pageNo - 1) / segmentSize < (this.totalPages - 1) / segmentSize;
    }

    public int getLSegmentNo(int segmentSize) {
        return (this.pageNo - 1) / segmentSize * segmentSize + 1;
    }

    public int getRSegmentNo(int segmentSize) {
        int rSegmentNo = ((this.pageNo - 1) / segmentSize + 1) * segmentSize + 1;
        return rSegmentNo > this.totalPages ? this.totalPages + 1 : rSegmentNo;
    }
}

