/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.logging.adapter;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogAdapter;
import org.zhiqim.kernel.logging.Logger;
import org.zhiqim.kernel.util.Classes;

public class Log4jLogger
implements LogAdapter,
Logger {
    private Method logerNameMethod;
    private Method logClassMethod;
    private HashMap<Integer, Method> logMap = new HashMap();
    private HashMap<Integer, Method> isMap = new HashMap();

    @Override
    public boolean adapter() {
        Class<?> log4jLogger = Classes.forName("org.apache.log4j.Logger");
        if (log4jLogger == null) {
            System.out.println("\u914d\u7f6e\u7684Log4j\u65e5\u5fd7\u5305\u4e0d\u5b58\u5728");
            return false;
        }
        Method[] methodArray = log4jLogger.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Classes.isStaticMethod(method)) {
                Class<?>[] classes;
                if ("getLogger".equals(method.getName()) && (classes = method.getParameterTypes()).length == 1) {
                    if (classes[0] == String.class) {
                        this.logerNameMethod = method;
                    } else if (classes[0] == Class.class) {
                        this.logClassMethod = method;
                    }
                }
            } else {
                Class<?> returnClass = method.getReturnType();
                Class<?>[] classes = method.getParameterTypes();
                if (returnClass == Boolean.TYPE && classes.length == 0) {
                    if ("isDebugEnabled".equals(method.getName())) {
                        this.isMap.put(1, method);
                    } else if ("isInfoEnabled".equals(method.getName())) {
                        this.isMap.put(2, method);
                    } else if ("isErrorEnabled".equals(method.getName())) {
                        this.isMap.put(3, method);
                    } else if ("isWarnEnabled".equals(method.getName())) {
                        this.isMap.put(4, method);
                    } else if ("isFatalEnabled".equals(method.getName())) {
                        this.isMap.put(5, method);
                    }
                } else if (returnClass == Void.TYPE && classes.length == 2 && classes[0] == Object.class && classes[1] == Throwable.class) {
                    if ("debug".equals(method.getName())) {
                        this.logMap.put(1, method);
                    } else if ("info".equals(method.getName())) {
                        this.logMap.put(2, method);
                    } else if ("error".equals(method.getName())) {
                        this.logMap.put(3, method);
                    } else if ("warn".equals(method.getName())) {
                        this.logMap.put(4, method);
                    } else if ("fatal".equals(method.getName())) {
                        this.logMap.put(5, method);
                    }
                }
            }
            ++n2;
        }
        if (this.logerNameMethod == null || this.logClassMethod == null || this.isMap.size() != 5 && this.logMap.size() != 5) {
            System.out.println("\u914d\u7f6e\u7684Log4j\u65e5\u5fd7\u5305\u4e0d\u6b63\u786e");
            return false;
        }
        return true;
    }

    @Override
    public void logger(Log log, int level, String message, Throwable throwable) {
        try {
            Object obj = null;
            obj = log.getMustClass() != null ? this.logClassMethod.invoke(null, log.getMustClass()) : this.logerNameMethod.invoke(null, log.getMustName());
            Method method = this.logMap.get(level);
            method.invoke(obj, message, throwable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isLoggerEnabled(Log log, int level) {
        try {
            Object obj = null;
            obj = log.getMustClass() != null ? this.logClassMethod.invoke(null, log.getMustClass()) : this.logerNameMethod.invoke(null, log.getMustName());
            Method method = this.isMap.get(level);
            return (Boolean)method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

