/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.logging;

import java.io.File;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.Servicer;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.schedule.ScheduleFactory;
import org.zhiqim.kernel.schedule.Scheduler;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.schedule.TaskThreader;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Linux;
import org.zhiqim.kernel.util.Systems;
import org.zhiqim.kernel.util.Validates;

public class LogLinuxCutter
extends Servicer
implements Task {
    private static final Log log = LogFactory.getLog(LogLinuxCutter.class);
    protected Scheduler scheduler;
    protected boolean schedulerCreated;
    protected int taskId;
    protected String filePath;
    protected String fileDir;
    protected String fileName;
    protected String fileBakDir;
    protected String schedule;
    protected int maxNum;
    protected int keepLogNum;

    @Override
    public boolean create() throws Exception {
        if (!Systems.isLinux()) {
            log.info((Object)"\u65e5\u5fd7\u5207\u5272\u5668[%s]\u7cfb\u7edf\u4e0d\u662flinux\uff0c\u4e0d\u5904\u7406", this.id);
            return true;
        }
        Group group = Global.getGroup(this.id);
        if (group == null) {
            log.error((Object)"\u65e5\u5fd7\u5207\u5272\u5668[%s]\u6ca1\u6709\u914d\u7f6e\u9879", this.id);
            return false;
        }
        this.filePath = group.getString("filePath");
        if (this.filePath == null) {
            log.error((Object)"\u65e5\u5fd7\u5207\u5272\u5668[%s.filePath]\u914d\u7f6e\u4e0d\u6b63\u786e", this.id);
            return false;
        }
        File file = new File(this.filePath);
        if (!Files.isFile(file) || !file.canRead()) {
            log.error((Object)"\u65e5\u5fd7\u5207\u5272\u5668[%s.filePath]\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6216\u4e0d\u80fd\u8bfb", this.id);
            return false;
        }
        this.fileName = file.getName();
        this.fileDir = Files.toLinuxPath(file.getParentFile().getCanonicalPath());
        this.fileBakDir = group.getString("fileBakDir");
        if (Validates.isEmptyBlank(this.fileBakDir)) {
            this.fileBakDir = this.fileDir;
        } else {
            Files.mkDirectory(this.fileBakDir);
            File fileDir = new File(this.fileBakDir);
            this.fileBakDir = Files.toLinuxPath(fileDir.getCanonicalPath());
        }
        this.schedule = group.getString("schedule", "{name:Day, param:0/0/0, first:false}");
        TaskThreader threader = ScheduleFactory.getTaskThreader((Task)this, this.schedule);
        if (threader == null) {
            log.error((Object)"\u65e5\u5fd7\u5207\u5272\u5668[%s.schedule]\u914d\u7f6e\u4e0d\u6b63\u786e", this.id);
            return false;
        }
        this.maxNum = group.getInt("maxNum", 0);
        if (this.maxNum < 0) {
            this.maxNum = 0;
        }
        if (this.maxNum > 90) {
            this.maxNum = 90;
        }
        this.keepLogNum = group.getInt("keepLogNum", 1);
        if (this.keepLogNum < 1) {
            this.keepLogNum = 1;
        }
        if (this.keepLogNum > 300) {
            this.keepLogNum = 300;
        }
        this.scheduler = Global.getService(Scheduler.class);
        if (this.scheduler == null) {
            this.scheduler = Global.getWithoutNew(Scheduler.class);
            this.scheduler.create();
            this.schedulerCreated = true;
        }
        this.taskId = this.scheduler.addTask(threader);
        log.info((Object)"\u65e5\u5fd7\u5207\u5272\u5668[%s][%s]\u521d\u59cb\u5316\u5b8c\u6210!!!", this.id, this.filePath);
        return true;
    }

    @Override
    public void destroy() throws Exception {
        if (this.scheduler != null && this.taskId != 0) {
            this.scheduler.removeTask(this.taskId);
        }
        if (this.schedulerCreated) {
            this.scheduler.destroy();
            this.scheduler = null;
        }
    }

    @Override
    public void execute() {
        try {
            log.info((Object)"\u65e5\u5fd7\u5207\u5272\u5668[%s]\u5207\u5272[%s]\u5f00\u59cb...", this.id, this.filePath);
            Files.removeMaxFileAndRenameFile(this.fileBakDir, this.fileName, this.maxNum, false);
            StringBuilder strb = new StringBuilder();
            if (this.maxNum > 0) {
                strb.append("cat ").append(this.filePath).append(" > ").append(this.fileBakDir).append("/").append(this.fileName).append(".1;");
            }
            strb.append("tail -").append(this.keepLogNum).append(" ").append(this.filePath).append(" > ").append(this.filePath).append(".tmp;");
            strb.append("cat ").append(this.filePath).append(".tmp > ").append(this.filePath).append(";");
            strb.append("rm -rf ").append(this.filePath).append(".tmp;");
            Linux.shell(strb.toString());
        }
        catch (Exception e) {
            log.error((Object)"\u65e5\u5fd7\u5207\u5272\u5668[%s]\u5207\u5272[%s]\u5931\u8d25", e, this.id, this.filePath);
        }
        log.info((Object)"\u65e5\u5fd7\u5207\u5272\u5668[%s]\u5207\u5272[%s]\u5b8c\u6210!!!", this.id, this.filePath);
    }
}

