/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.extend;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.zhiqim.kernel.ZhiqimI18n;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.extend.MapSV;
import org.zhiqim.kernel.util.Asserts;

@AnAlias(value={"LinkedMapSV"})
@AnNew
public class LinkedMapSV<V>
extends HashMapSV<V> {
    public LinkedMapSV() {
        this.instance = new LinkedHashMap();
    }

    public LinkedMapSV(int count) {
        this.instance = new LinkedHashMap(count);
    }

    public LinkedMapSV(int initialCapacity, float loadFactor, boolean accessOrder) {
        this.instance = new LinkedHashMap(initialCapacity, loadFactor, accessOrder);
    }

    public LinkedMapSV(String key, V value) {
        this.instance = new LinkedHashMap(1);
        this.instance.put(key, value);
    }

    public LinkedMapSV(Map<String, V> instance) {
        this.instance = new LinkedHashMap<String, V>(instance);
    }

    public LinkedMapSV(MapSV<V> instance) {
        this.instance = new LinkedHashMap<String, V>(instance.instance());
    }

    public Object[] toArray() {
        return this.instance.values().toArray();
    }

    public V get(int index) {
        Asserts.asserts(index >= 0, ZhiqimI18n.indexMustBeGreaterThanOrEqualZero);
        if (index >= this.instance.size()) {
            return null;
        }
        Set entrySet = this.instance.entrySet();
        Iterator it = entrySet.iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (index <= i) {
                if (index != i) break;
                return entry.getValue();
            }
            ++i;
        }
        return null;
    }
}

