/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.zhiqim.kernel.constants.SignConstants;
import org.zhiqim.kernel.constants.ZhiqimConstants;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Lists;
import org.zhiqim.kernel.util.Systems;

final class ZhiqimClasspath
implements ZhiqimConstants,
SignConstants {
    private List<String> classpathList = new ArrayList<String>();
    private ClassLoader parentLoader = null;
    private ZhiqimBootLoader classLoader = null;

    ZhiqimClasspath() {
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void initClasspath(String libPaths) throws IOException {
        this.classpathList.clear();
        HashSet<String> alreadys = new HashSet<String>();
        File libFolder = new File("./lib");
        this.addJarFolder("./lib", libFolder);
        alreadys.add(libFolder.getCanonicalPath());
        List<String> libPathList = Lists.toStringList(libPaths);
        for (String libPath : libPathList) {
            String canonicalPath;
            File libDir = new File(libPath);
            if (!Files.isDirectory(libDir) || alreadys.contains(canonicalPath = libDir.getCanonicalPath())) continue;
            this.addJarFolder(libPath, libDir);
            alreadys.add(canonicalPath);
        }
        Systems.setClassPath(this.toString());
        this.classLoader = this.getClassLoaderNew();
        Thread.currentThread().setContextClassLoader(this.classLoader);
    }

    public void releaseClasspath() {
        Thread.currentThread().setContextClassLoader(this.parentLoader);
        try {
            this.classLoader.close();
        }
        catch (IOException iOException) {}
    }

    private void addJarFolder(String libPath, File libDir) throws IOException {
        File[] jarFileArr = libDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File dir) {
                String name = dir.getName().toLowerCase();
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        });
        int i = 0;
        while (i < jarFileArr.length) {
            this.addJarFile(jarFileArr[i]);
            ++i;
        }
        Systems.addLibraryPath(libPath);
    }

    private boolean addJarFile(File jar) throws IOException {
        if (jar == null || !jar.exists()) {
            return false;
        }
        String key = jar.getCanonicalPath();
        if (!this.classpathList.contains(key)) {
            this.classpathList.add(key);
            return true;
        }
        return false;
    }

    private ZhiqimBootLoader getClassLoaderNew() throws MalformedURLException {
        int size = this.classpathList.size();
        URL[] urls = new URL[size];
        int i = 0;
        while (i < size) {
            urls[i] = new File(this.classpathList.get(i)).toURI().toURL();
            ++i;
        }
        this.parentLoader = Thread.currentThread().getContextClassLoader();
        if (this.parentLoader == null) {
            this.parentLoader = ZhiqimClasspath.class.getClassLoader();
        }
        if (this.parentLoader == null) {
            this.parentLoader = ClassLoader.getSystemClassLoader();
        }
        return new ZhiqimBootLoader(urls, this.parentLoader);
    }

    public String toString() {
        int size = this.classpathList.size();
        if (size == 0) {
            return "";
        }
        StringBuilder strb = new StringBuilder(1024);
        strb.append(this.classpathList.get(0));
        int i = 1;
        while (i < size) {
            strb.append(File.pathSeparatorChar).append(this.classpathList.get(i));
            ++i;
        }
        return strb.toString();
    }

    private class ZhiqimBootLoader
    extends URLClassLoader {
        private String name;

        private ZhiqimBootLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
            this.name = "ZhiqimBootLoader";
        }

        public String toString() {
            return this.name;
        }
    }
}

