/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙标记语言（zhiqim_zml）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_zml.htm
 *
 * This file is part of [zhiqim_zml].
 * 
 * [zhiqim_zml] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_zml] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_zml].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.zml.loader;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.util.Resources;

/**
 * ZML类目录检查，所有包含*.zml文件的包，当前采用11秒内不检查
 * TODO 在1.4版本后续中进行优化
 *
 * @version v1.0.0 @author zouzhigang 2016-7-13 新建与整理
 */
public class ClassZmlWatcher
{
    private final Class<?> loadClass;
    private final String pathPrefix;
    private final HashMapSV<long[]> modifiedMap;
    
    public ClassZmlWatcher(Class<?> loadClass, String pathPrefix)
    {
        this.loadClass = loadClass;
        this.pathPrefix = pathPrefix;
        this.modifiedMap = new HashMapSV<>();
    }
    
    public long getLastModified(String path)
    {
        long[] value = modifiedMap.get(path);
        if (value != null)
        {
            if (System.currentTimeMillis() - value[1] < 11 * 1000)
                return value[0];//11秒内不再检查更新
        }
        
        URL url = Resources.getResource(loadClass, pathPrefix + path);
        if (url == null)
        {//未找到，直接返回-1
            modifiedMap.remove(path);
            return -1;
        }
        
        try
        {
            URLConnection conn = url.openConnection();
            long lastModified = conn.getLastModified();
            modifiedMap.put(path, new long[]{lastModified, System.currentTimeMillis()});
            return lastModified;
        }
        catch (IOException e)
        {
            modifiedMap.remove(path);
            return -1;
        }
    }
}
