/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙标记语言（zhiqim_zml）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_zml.htm
 *
 * This file is part of [zhiqim_zml].
 * 
 * [zhiqim_zml] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_zml] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_zml].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.zml.expression.primitive;

import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.expression.Primitive;

/**
 * 整数原型，byte/short/int/long，非零数字开头数字连贯出现"^[1-9]\\d*$"<br><br>
 * 但是实际中可能出现0123，这种情况，和点号一起组合成_Decimal
 *
 * @see Byte        一个字节
 * @see Short       二个字节
 * @see Integer     四个字节
 * @see Long        八个字节
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class _Integer extends Primitive
{
    private final String value;
    
    public _Integer(String value)
    {
        this.value = value;
    }
    
    @Override
    public int getType()
    {
        return NUMBERIC;
    }
    
    @Override
    public Object build(ZmlVariable variableMap) throws ExpressionException
    {
        return Long.parseLong(value);
    }
    
    @Override
    public String toString()
    {
        return value;
    }

    public long getLong()
    {
        return Long.parseLong(value);
    }
    
    public int getInt()
    {
        return Integer.parseInt(value);
    }
    
    public short getShort()
    {
        return Short.parseShort(value);
    }
    
    public byte getByte()
    {
        return Byte.parseByte(value);
    }
}
