/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙标记语言（zhiqim_zml）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_zml.htm
 *
 * This file is part of [zhiqim_zml].
 * 
 * [zhiqim_zml] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_zml] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_zml].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.zml;

/**
 * ZhiqimML加载接口定义
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public interface ZmlLoader extends ZmlConstants
{
    /** 获取上下文环境路径 */
    public String getContextPath();
    
    /**
     * 判断ZML是否存在
     * 
     * @param path          ZML路径
     * @return              是否存在true/false
     * @throws              可能的异常
     */
    public boolean hasZml(String path) throws Exception;
    
    /**
     * 加载ZML接口
     * 
     * @param path          相对于根配置的路径，如/zview/include.zml
     * @return              返回Zml对象
     * @throws              可能的异常
     */
    public Zml loadZml(String path) throws Exception;
    
    /**
     * 获取ZML资源最后更新时间
     * 
     * @param path          相对于根配置的路径，如/zview/include.zml
     * @return long         最后修改时间
     * @throws              可能的异常
     */
    public long getLastModified(String path) throws Exception;
    
    /** 
     * 设置ZML缓存最长空闲时长
     * 
     * @param maxIdleTime   最长空闲时长，单位：秒
     */
    public void setMaxIdleTime(int maxIdleTime);
    
    /**
     * 设置ZML缓存最长保持时长
     * 
     * @param maxKeepTime   最长保持时长，单位：秒
     */
    public void setMaxKeepTime(int maxKeepTime);
}
