/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.xml;

import org.w3c.dom.Node;

/**
 * Xml解析器接口
 *
 * @version v1.1.2 @author zouzhigang 2015-8-21 新建与整理
 */
public interface XmlParser
{
    /**
     * 设置Xml解析主类
     * 
     * @param xmlMain XML解析主类
     */
    public XmlParser set(Xml xmlMain);
    
    /**
     * 解析对象成XML字符串
     * 
     * @param obj       本字段对象
     * @param tagName   本字段标志
     * @param tagLevel  本字段级别
     * @return          XML字符串
     */
    public String toStringInner(Object obj, String tagName, int tagLevel);
    
    /**
     * 解析XML字符串成对象
     * 
     * @param xml XML字符串
     * @param clazz 对象类结构
     * @return 返回对象
     */
    public Object toObjectInner(Node node, Class<?> clazz, Class<?> generics);
}
