/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util.streams;

import java.io.IOException;
import java.io.InputStream;

/**
 * 记录输入流长度的自定义输入流
 *
 * @version v1.0.0 @author zouzhigang 2017-6-14 新建与整理
 */
public class LengthInputStream extends InputStream
{
    private InputStream in;
    private long length;

    public LengthInputStream(InputStream in)
    {
        this.in = in;
    }
    
    
    public long length()
    {
        return length;
    }

    public int read() throws IOException
    {
        int c = in.read();
        if (c != -1)
            length++;
        
        return c;
    }
    
    public int read(byte[] b, int off, int len) throws IOException
    {
        int result = in.read(b, off, len);
        if (result != -1)
            length += len;
        
        return result;
    }
}
