/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util.streams;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;

/**
 * 摘要输出流，写入流的同时，记录长度和更新摘要信息
 *
 * @version v1.0.0 @author zouzhigang 2016-12-12 新建与整理
 */
public class DigestOutputStream extends FilterOutputStream
{
    private MessageDigest digest;
    private long length;

    public DigestOutputStream(OutputStream stream, MessageDigest digest)
    {
        super(stream);
        this.digest = digest;
    }
    
    /**************************************************************************/
    //写入流，同时更新摘要和数目
    /**************************************************************************/

    public void write(int b) throws IOException
    {
        out.write(b);
        digest.update((byte) b);
        length++;
    }

    public void write(byte[] b, int off, int len) throws IOException
    {
        out.write(b, off, len);
        digest.update(b, off, len);
        length += len;
    }
    
    public void write(byte[] b) throws IOException
    {
        out.write(b);
        digest.update(b);
        length += b.length;
    }
    
    /**************************************************************************/
    //获取最终摘要和数目
    /**************************************************************************/

    public MessageDigest getMessageDigest()
    {
        return digest;
    }
    
    public byte[] digest()
    {
        return digest.digest();
    }
    
    public long length()
    {
        return length;
    }

    public String toString()
    {
        return "[DigestOutputStream] " + digest.toString();
    }
}