/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util.seqs;

import org.zhiqim.kernel.util.DateTimes;

/**
 * 整型序列值，默认从1从0x7FFFFFFF(最大值)，每天重新开始<br><br>
 * 1、最小值必须>=1<br>
 * 2、如果设置最大值，则最大值必须大小最小值，否则取整数最大值0x7FFFFFFF
 * 
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
public class SequenceDate extends Sequence
{
    private String date = DateTimes.getDateString();
    
    /** 从1到0x7FFFFFFF */
    public SequenceDate()
    {
    }
    
    /** 从1到len个9 */
    public SequenceDate(int len)
    {
        super(len);
    }
    
    /** 从min到max */
    public SequenceDate(long min, long max)
    {
        super(min, max);
    }
    
    /** 从min到max，指定初始值 */
    public SequenceDate(long min, long max, long seq)
    {
        super(min, max, seq);
    }
    
    public String getDate()
    {
        return date;
    }
    
    /********************************************************************/
    //重写获取方法，按天判断
    /********************************************************************/
    
    @Override
    public long next()
    {
        synchronized (this)
        {
            String curDate = DateTimes.getDateString();
            if (curDate.equals(date)){
                chkSequence();
            }else{
                resetSequence();
                date = curDate;
            }
            
            return sequence++;
        }
    }
}
