/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util.mutables;

import org.zhiqim.kernel.constants.SignConstants;

/**
 * 定义可变的字节缓冲，用于线程内重复使用缓冲
 *
 * @version v1.0.0 @author zouzhigang 2017-5-19 新建与整理
 */
public final class MBuf implements SignConstants, AutoCloseable
{
    public byte[] value;
    
    /*******************************************************/
    //两个构造函数，默认1KiB
    /*******************************************************/
    
    public MBuf()
    {
        this(KiB);
    }
    
    public MBuf(int len)
    {
        value = new byte[len];
    }
    
    
    /*******************************************************/
    //常用方法
    /*******************************************************/
    
    public byte[] val()
    {
        return value;
    }
    
    public MBuf val(byte[] val)
    {
        this.value = val;
        return this;
    }
    
    public MBuf val(MBuf val)
    {
        this.value = val.value;
        return this;
    }
    
    public int len()
    {
        return value.length;
    }
    
    /*******************************************************/
    //实现关闭
    /*******************************************************/
    
    public void close()
    {
        value = null;
    }
}
