/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.RegexpConstants;
import org.zhiqim.kernel.constants.SignConstants;

/**
 * 替换静态方法
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("Replaces")
public class Replaces implements RegexpConstants, SignConstants
{
    /**
     * 替换单引号'成\'
     * 
     * @param str   原字符串
     * @return      新字符串
     */
    public static String replaceQuotation(String str)
    {
        if (Validates.isEmpty(str))
            return str;
        
        return str.replaceAll("\'", "\\\\\'");
    }
    
    /**
     * 替换单引号"成\"
     * 
     * @param str   原字符串
     * @return      新字符串
     */
    public static String replaceDoubleQuotation(String str)
    {
        if (Validates.isEmpty(str))
            return str;
        
        return str.replaceAll("\"", "\\\\\"");
    }
    
    /**
     * 替换反斜杠\成指定的字符
     * 
     * @param str           原字符串
     * @param replacement   \替换成后字符串
     * @return              新字符串
     */
    public static String replaceBackslash(String str, String replacement)
    {
        return replaceAllEscape(str, "\\", replacement);
    }
    
    /**
     * 替换掉所有的符号
     * 
     * @param str       原字符串
     * @return          新字符串
     */
    public static String replaceAllSymbols(String str)
    {
        if (Validates.isEmptyBlank(str))
            return str;
        
        return str.replaceAll(SYMBOLS_ALL, _EMPTY_);
    }
    
    /**
     * 替换掉通用符号
     * 
     * @param str       原字符串
     * @return          新字符串
     */
    public static String replaceSymbols(String str)
    {
        if (Validates.isEmptyBlank(str))
            return str;
        
        return str.replaceAll(SYMBOLS_UNICODE, _EMPTY_);
    }
    
    /**
     * 替换掉IOS表情符号
     * 
     * @param str       原字符串
     * @return          新字符串
     */
    public static String replaceEmojiIOS(String str)
    {
        if (Validates.isEmptyBlank(str))
            return str;
        
        return str.replaceAll(SYMBOLS_EMOJI_IOS, _EMPTY_);
    }
    
    /**
     * 替换字符串regex成replacement，注意这里会对regex全正则表达式字符转义后再替换
     * 
     * @param src           原字符串
     * @param regex         要替换的字符串
     * @param replacement   替换成新的字符串
     * @return              替换
     */
    public static String replaceAllEscape(String str, String regex, String replacement)
    {
        if (Validates.isEmpty(str))
            return str;
        
        //对被替换字符进行转义
        StringBuilder strb = new StringBuilder();
        for (int i=0;i<regex.length();i++)
        {
            char c = regex.charAt(i);
            if (Validates.isCharInString(c, ESCAPE))
                strb.append("\\");
            
            strb.append(c);
        }
        regex = strb.toString();
        
        //对替换后字符进行转义
        strb = new StringBuilder();
        for (int i=0;i<replacement.length();i++)
        {
            char c = replacement.charAt(i);
            if (Validates.isCharInString(c, ESCAPE))
                strb.append("\\");
            
            strb.append(c);
        }
        replacement = strb.toString();
        
        //最后再作替换
        return str.replaceAll(regex, replacement);
    }
    
    /**
     * 把要替换的字符串进行转义检查，得到转义后的字符
     * 
     * @param replace   要转义的字符串
     * @return          转义后的字符串
     */
    public static String toReplaceEscape(String replace)
    {
        StringBuilder strb = new StringBuilder();
        for (int i=0;i<replace.length();i++)
        {
            char c = replace.charAt(i);
            if (Validates.isCharInString(c, ESCAPE))
                strb.append("\\");
            
            strb.append(c);
        }
        
        return strb.toString();
    }
}
