/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util;

import java.text.DecimalFormat;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.SignConstants;

/**
 * 数学相关工具类
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
@AnAlias("Maths")
public class Maths implements SignConstants
{
    /**
     * 提供被除数，除数和小数位数，得到结果
     * 
     * @param dividend  被除数，字符串格式
     * @param divisor   除数
     * @param radixLen  小数位数
     * @return          String 结果
     */
    public static String division(String dividend, long divisor, int radixLen)
    {
        long dividendLong = Long.parseLong(dividend);
        return division(dividendLong, divisor, radixLen);
    }
    
    /**
     * 提供被除数，除数和小数位数，得到结果
     * 
     * @param dividend  被除数，数值格式
     * @param divisor   除数
     * @param radixLen  小数位数
     * @return          String 结果
     */
    public static String division(long dividend, long divisor, int radixLen)
    {
        if (radixLen <= 0)
            return (dividend / divisor)+"";
        
        double result = (double)dividend / divisor;
        StringBuilder radix = new StringBuilder("#");
        if (radixLen > 0)
        {
            radix.append(".");
            for (int i=0;i<radixLen;i++)
                radix.append("#");
        }
        
        DecimalFormat df = new DecimalFormat(radix.toString());
        String ret = df.format(result);
        
        if (radixLen > 0)
        {
            int ind = ret.indexOf('.');
            if (ind == -1)
            {//没有小数点
                ret += ".";
                for (int i=0;i<radixLen;i++)
                    ret += "0";
            }
            else if (ind > ret.length() - radixLen -1)
            {//小数位数不足,尾部加0
                int zeroNum = ind - (ret.length() - radixLen - 1);
                for (int i=0;i<zeroNum;i++)
                {
                    ret += "0";
                }
            }
        }
        
        return ret;
    }
    
    /**
     * 对整数增加千分号后，转为字符串，如32323211转为32,323,211
     * 
     * @param value     整数，如：32323211
     * @return          加千分号的字符串，如：32,323,211
     */
    public static String permil(long value)
    {
        StringBuilder strb = new StringBuilder();
        while (value >= 1000)
        {
            long remainder = value % 1000;
            value = value / 1000;
            
            strb.insert(0, Strings.prefixZero(remainder, 3));
            strb.insert(0, ",");
        }
        
        strb.insert(0, value);
        return strb.toString();
    }
    
    /**
     * 对文件大小进行K/M/G处理，保留指定小数位数
     * 
     * @param value     大小值
     * @param radixLen  小数位数
     * @return          转为K/M/G的小数值
     */
    public static String size(long value, int radixLen)
    {
        if (value < KiB)
            return value + "B";
        else if (value < MiB)
            return division(value, KiB, radixLen) + "K";
        else if (value < GiB)
            return division(value, MiB, radixLen) + "M";
        else
            return division(value, GiB, radixLen) + "G";
    }
}
