/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import org.zhiqim.kernel.annotation.AnAlias;

/**
 * 列表类静态扩展类
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("Listx")
public class Listx extends Collectionx
{
    // Query Operations 查询操作
    
    public static int size(List<?> list)
    {
        return (list == null)?0:list.size();
    }
    
    public static boolean isEmpty(List<?> list)
    {
        return (list == null)?true:list.isEmpty();
    }
    
    public static boolean contains(List<?> list, Object o)
    {
        return (list == null)?false:list.contains(o);
    }
    
    public static <E> Iterator<E> iterator(List<E> list)
    {
        return list.iterator();
    }
    
    public static Object[] toArray(List<?> list)
    {
        return list.toArray();
    }
    
    public static <T> T[] toArray(List<T> list, T[] a)
    {
        return list.toArray(a);
    }
    
    // Modification Operations 修改操作
    
    public static <E> boolean add(List<E> list, E e)
    {
        return (list == null)?false:list.add(e);
    }
    
    public static boolean remove(List<?> list, Object o)
    {
        return (list == null)?false:list.remove(o);
    }
    
    // Bulk Modification Operations 批量修改操作
    
    public static boolean containsAll(List<?> list, Collection<?> c)
    {
        return (list == null)?false:list.containsAll(c);
    }
    
    public static <E> boolean addAll(List<E> list, Collection<? extends E> c)
    {
        return (list == null)?false:list.addAll(c);
    }
    
    public static <E> boolean addAll(List<E>list, int index, Collection<? extends E> c)
    {
        return (list == null)?false:list.addAll(index, c);
    }
    
    public static boolean removeAll(List<?> list, Collection<?> c)
    {
        return (list == null)?false:list.removeAll(c);
    }
    
    public static boolean retainAll(List<?> list, Collection<?> c)
    {
        return (list == null)?false:list.retainAll(c);
    }
    
    public static void clear(List<?> list)
    {
        if (list == null)
            return;
       
        list.clear();
    }
    
    // Comparison and hashing  
    
    public static boolean equals(List<?> list, Object o)
    {
        return list.equals(o);
    }
    
    public static int hashCode(List<?> list)
    {
        return list.hashCode();
    }
    
    // Positional Access Operations 
    
    public static <E> E get(List<E> list, int index)
    {
        return list.get(index);
    }
    
    public static <E> E set(List<E> list, int index, E element)
    {
        return list.set(index, element);
    }
    
    public static <E> void add(List<E> list, int index, E element)
    {
        list.add(index, element);
    }
    
    public static <E> E remove(List<E> list, int index)
    {
        return list.remove(index);
    }
    
    public static int indexOf(List<?> list, Object o)
    {
        return list.indexOf(o);
    }
    
    public static int lastIndexOf(List<?> list, Object o)
    {
        return list.lastIndexOf(o);
    }
    
    public static <E> ListIterator<E> listIterator(List<E> list)
    {
        return list.listIterator();
    }
    
    public static <E> ListIterator<E> listIterator(List<E> list, int index)
    {
        return list.listIterator(index);
    }
    
    public static <E> List<E> subList(List<E> list, int fromIndex, int toIndex)
    {
        return list.subList(fromIndex, toIndex);
    }
}
