/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util;

import java.util.Collection;
import java.util.Iterator;

import org.zhiqim.kernel.annotation.AnAlias;

/**
 * 集合类静态扩展类
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("Collectionx")
public class Collectionx extends Iterablex
{
    // Query Operations
    
    public static int size(Collection<?> collection)
    {
        return (collection == null)?0:collection.size();
    }

    public static boolean isEmpty(Collection<?> collection)
    {
        return (collection == null)?true:collection.isEmpty();
    }

    public static <E> boolean contains(Collection<E> collection, Object o)
    {
        return (collection == null)?false:collection.contains(o);
    }

    public static <E> Iterator<E> iterator(Collection<E> collection)
    {
        return collection.iterator();
    }

    public static Object[] toArray(Collection<?> collection)
    {
        return collection.toArray();
    }

    public static <T> T[] toArray(Collection<?> collection, T[] a)
    {
        return collection.toArray(a);
    }

    // Modification Operations

    public static <E> boolean add(Collection<E> collection, E e)
    {
        return (collection == null)?false:collection.add(e);
    }

    public static boolean remove(Collection<?> collection, Object o)
    {
        return (collection == null)?false:collection.remove(o);
    }


    // Bulk Operations

    public static <E> boolean containsAll(Collection<E> collection, Collection<?> c)
    {
        return (collection == null)?false:collection.containsAll(c);
    }

    public static <E> boolean addAll(Collection<E> collection, Collection<? extends E> c)
    {
        return (collection == null)?false:collection.addAll(c);
    }

    public static boolean removeAll(Collection<?> collection)
    {
        return (collection == null)?false:collection.removeAll(collection);
    }
    
    public static boolean retainAll(Collection<?> collection, Collection<?> c)
    {
        return (collection == null)?false:collection.retainAll(c);
    }

    public static void clear(Collection<?> collection)
    {
        if (collection == null)
            return;
        
        collection.clear();
    }


    // Comparison and hashing

    public static boolean equals(Collection<?> collection, Object o)
    {
        return (collection == null)?(o == null):collection.equals(o);
    }

    public static int hashCode(Collection<?> collection)
    {
        return (collection == null)?0:collection.hashCode();
    }
}
