/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnGenerics;

/**
 * 注解工具类
 *
 * @version v1.0.0 @author zouzhigang 2016-12-23 新建与整理
 */
@AnAlias("Annotations")
public class Annotations
{
    /********************************************************/
    //以下为类相关注解
    /********************************************************/
    
    /**
     * 获取类可能的别名
     * 
     * @param clazz 类结构
     * @return      类别名，如果没有或为空白还回null
     */
    public static String getClassAlias(Class<?> clazz)
    {
        AnAlias alias = clazz.getAnnotation(AnAlias.class);
        if (alias != null && !Validates.isEmptyBlank(alias.value()[0]))
            return alias.value()[0].trim();
        
        return null;
    }
    
    /********************************************************/
    //以下为字段相关注解
    /********************************************************/
    
    /**
     * 获取字段的名称，如果有指定Alias且不为空，取Alias中的值，否则取field.getName()
     * 
     * @param field 字段
     * @return      该字段的名称或配置Alias的值
     */
    public static String getFieldName(Field field)
    {
        AnAlias alias = field.getAnnotation(AnAlias.class);
        if (alias != null && Validates.isNotEmptyBlank(alias.value()[0]))
            return alias.value()[0].trim();
        else
            return field.getName();
    }
    
    /**
     * 获取字段的泛型，当为Collection的子类时有效，如果传入的是数组，直接返回数组组件类型
     * 
     * @param field 字段
     * @return      该字段的名称或配置Generics的值
     */
    public static Class<?> getGenericsClass(Field field)
    {
        if (Types.isArray(field.getType()))
            return field.getType().getComponentType();
        
        AnGenerics generics = field.getAnnotation(AnGenerics.class);
        return generics == null?null:generics.value();
    }
    
    /********************************************************/
    //以下为方法相关注解
    /********************************************************/
    
    /**
     * 获取方法的名称，如果有指定Alias且不为空，取Alias中的值，否则取method.getName()
     * 
     * @param method 方法
     * @return       该方法的名称或配置Alias的值
     */
    public static String getMethodName(Method method)
    {
        AnAlias alias = method.getAnnotation(AnAlias.class);
        if (alias != null && Validates.isNotEmptyBlank(alias.value()[0]))
            return alias.value()[0].trim();
        else
            return method.getName();
    }
    
    /**
     * 获取方法的别名，如果没有或为空白，返回null
     * 
     * @param method 方法
     * @return       该方法配置Alias的值
     */
    public static String getMethodAlias(Method method)
    {
        AnAlias alias = method.getAnnotation(AnAlias.class);
        if (alias == null || Validates.isEmptyBlank(alias.value()[0]))
            return null;
        
        return alias.value()[0].trim();
    }
    
    /**
     * 判断指定的名称是不是访方法的名称或别名
     * 
     * @param method 方法
     * @param name   名称
     * @return       =true表示匹配成功
     */
    public boolean isMethodNameOrAlias(Method method, String name)
    {
        if (Validates.isEmptyBlank(name))
            return false;
        
        if (name.equals(method.getName()))
            return true;
        
        AnAlias alias = method.getAnnotation(AnAlias.class);
        return (alias != null && name.equals(alias.value()[0].trim()));
    }
}
