/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.tree;

import java.util.List;

import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Validates;

/**
 * 树生成器
 *
 * @version v1.0.0 @author zouzhigang 2017-8-12 新建与整理
 */
public class TreeBuilder
{
    /**
     * 生成新的树型模式
     * 
     * @param list          列表
     * @param treer         判断器
     * @return              树对象
     */
    public static <E> Tree<E> newTree(List<E> list, Treer<E> treer)
    {
        Asserts.as(Validates.isNotEmpty(list)?null:"树型对象要求列表不能为空");
        Asserts.as(treer != null?null:"树型对象要求判断器不能为空");
        
        return new Tree<E>(list.get(0), treer).build(list);
    }
    
    /**
     * 生成新的树型模式
     * 
     * @param list          列表
     * @param pFieldName    父字段方法名
     * @param sFieldName    自字段方法名
     * @return              树对象
     */
    public static <E> Tree<E> newTree(List<E> list, String pFieldName, String sFieldName)
    {
        Asserts.as(Validates.isNotEmpty(list)?null:"树型对象要求列表不能为空");
        return new Tree<E>(list.get(0), new TreeFielder<E>(pFieldName, sFieldName)).build(list);
    }
}
