/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.logging.adapter;

import java.lang.reflect.Method;
import java.util.HashMap;

import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogAdapter;
import org.zhiqim.kernel.logging.Logger;
import org.zhiqim.kernel.util.Classes;

/**
 * 适配Log4j的日志，只支持三种，DEBUG,INFO,ERROR，对应FINE,INFO,SEVERE
 *
 * @version v1.0.0 @author zouzhigang 2016-1-9 新建与整理
 */
public class Log4jLogger implements LogAdapter, Logger
{
    //以下为日志输出器获取属性
    private Method logerNameMethod;
    private Method logClassMethod;
    
    //以下为日志输出方法属性
    private HashMap<Integer, Method> logMap = new HashMap<Integer, Method>();
    private HashMap<Integer, Method> isMap = new HashMap<Integer, Method>();
    
    /** 初始化适配器 */
    public boolean adapter()
    {
        //第一步，判断Log4j类在不在
        Class<?> log4jLogger = Classes.forName(LOG4J_LOGGER_CLASS);
        if (log4jLogger == null)
        {
            System.out.println("配置的Log4j日志包不存在");
            return false;
        }
        
        //第二步，找到Log4j类使用的12个方法
        for (Method method :log4jLogger.getMethods())
        {
            if (Classes.isStaticMethod(method))
            {//找到Logger.getLogger(String)和Logger.getLogger(Class)两个方法
                if (!LOG4J_LOGGER_METHOD.equals(method.getName()))
                    continue;
                
                Class<?>[] classes = method.getParameterTypes();
                if (classes.length != 1)
                    continue;
                
                if (classes[0] == String.class)
                    logerNameMethod = method;
                else if (classes[0] == Class.class)
                    logClassMethod = method;
            }
            else
            {//找到5个判断方法和5个操作方法
                Class<?> returnClass = method.getReturnType();
                Class<?>[] classes = method.getParameterTypes();
                if (returnClass == boolean.class && classes.length == 0)
                {//5个判断方法
                    if (LOG4J_LOGGER_IS_DEBUG.equals(method.getName()))
                        isMap.put(DEBUG, method);
                    else if (LOG4J_LOGGER_IS_INFO.equals(method.getName()))
                        isMap.put(INFO, method);
                    else if (LOG4J_LOGGER_IS_ERROR.equals(method.getName()))
                        isMap.put(ERROR, method);
                    else if (LOG4J_LOGGER_IS_WARN.equals(method.getName()))
                        isMap.put(WARN, method);
                    else if (LOG4J_LOGGER_IS_FATAL.equals(method.getName()))
                        isMap.put(FATAL, method);
                }
                else if (returnClass == void.class && classes.length == 2 && classes[0] == Object.class && classes[1] == Throwable.class)
                {//5个操作方法
                    if (LOG4J_LOGGER_DEBUG.equals(method.getName()))
                        logMap.put(DEBUG, method);
                    else if (LOG4J_LOGGER_INFO.equals(method.getName()))
                        logMap.put(INFO, method);
                    else if (LOG4J_LOGGER_ERROR.equals(method.getName()))
                        logMap.put(ERROR, method);
                    else if (LOG4J_LOGGER_WARN.equals(method.getName()))
                        logMap.put(WARN, method);
                    else if (LOG4J_LOGGER_FATAL.equals(method.getName()))
                        logMap.put(FATAL, method);
                }
            }
        }
        
        if (logerNameMethod == null || logClassMethod == null || isMap.size() != 5 && logMap.size() != 5)
        {
            System.out.println("配置的Log4j日志包不正确");
            return false;
        }
        
        return true;
    }
    
    /**
     * 日志记录器记录日志
     * 
     * @param log       日志对象
     * @param level     日志级别
     * @param message   日志消息
     * @param throwable 日志异常
     */
    public void logger(Log log, int level, String message, Throwable throwable)
    {
        try
        {
            Object obj = null;
            if (log.getMustClass() != null)
                obj = logClassMethod.invoke(null, log.getMustClass());
            else
                obj = logerNameMethod.invoke(null, log.getMustName());
            
            Method method = logMap.get(level);
            method.invoke(obj, message, throwable);
        }
        catch(Exception e)
        {
            e.printStackTrace();
        }
    }
    
    /**
     * 判断日志级别是否开启
     * 
     * @param log   日志对象
     * @param level 日志级别
     * @return      =true表示开启，=false表示关闭
     */
    public boolean isLoggerEnabled(Log log, int level)
    {
        try
        {
            Object obj = null;
            if (log.getMustClass() != null)
                obj = logClassMethod.invoke(null, log.getMustClass());
            else
                obj = logerNameMethod.invoke(null, log.getMustName());
            
            Method method = isMap.get(level);
            return (Boolean)method.invoke(obj);
        }
        catch(Exception e)
        {
            e.printStackTrace();
            return false;
        }
    }
}
