/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.json;

/**
 * JSON 主程序，对象转换成JSON和JSON转换成对象
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class Json
{
    public static final Json json = new Json();
    
    private boolean isJsLongToString = true;                //是否适配JS中超过2^53时long转为String
    private JsonFactory factory = new JsonFactory(this);
    
    /**
     * 对象转换成JSON字符串
     * 
     * @param obj   对象
     * @return      JSON字符串
     */
    public String toString(Object obj)
    {
        if (obj == null)
            return "null";
        
        return factory.getParser(obj.getClass()).toString(obj);
    }
    
    /**
     * JSON字符串转换成对象
     * 
     * @param json      JSON字符串
     * @param clazz     转换成对象的类
     * @return          obj对象
     */
    public <T> T toObject(String json, Class<T> clazz)
    {
        return toObject(json, clazz, true);
    }
    
    /**
     * JSON字符串转换成对象
     * 
     * @param json      JSON字符串
     * @param cls     转换成对象的类
     * @param chkSpace  是否检查空格
     * @return          obj对象
     */
    @SuppressWarnings("unchecked")
    public <T> T toObject(String json, Class<T> cls, boolean chkSpace)
    {
        if (json == null || cls == null)
            return null;
        
        if (chkSpace)
            json = Jsons.removeBlankSpace(json);
        
        if ("null".equals(json))
            return null;
        
        return (T)factory.getParser(cls).toObject(json, cls);
    }

    /***************************************************************/
    //以下为JSON定义的解析参数
    /***************************************************************/
    
    public boolean isJsLong()
    {
        return isJsLongToString;
    }

    public Json setJsLongToString(boolean isJsLongToString)
    {
        this.isJsLongToString = isJsLongToString;
        return this;
    }
}
