/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.httpclient;

import java.io.IOException;
import java.net.HttpURLConnection;

import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

/**
 * HTTP/HTTPS PUT请求
 * 1.和POST不同的时PUT以流为主，传入bytes
 * 2.和POST不同的是mimeType和encoding可以为null则不传入
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class HttpPut extends HttpClient
{
    private byte[] bytes;
    private String mimeType;
    private String encoding;
    
    public HttpPut(String url)
    {
        super(url, _PUT_);
    }
    
    public void setContentType(String mimeType, String encoding)
    {
        this.mimeType = Strings.trim(mimeType);
        this.encoding = Strings.trim(encoding);
    }

    public void setBytes(byte[] bytes)
    {
        this.bytes = bytes;
    }
    
    protected boolean doPreRequestProperty()
    {
        if (bytes == null || bytes.length == 0)
            return true;
        
        setDoOutput(true);
        if (!hasRequestProperty("Content-Type") && Validates.isNotEmpty(mimeType))
        {//有可能在执行前已设置属性
            if (Validates.isEmpty(encoding))
                addRequestProperty("Content-Type", mimeType);
            else
                addRequestProperty("Content-Type", mimeType + "; charset="+encoding);
        }
        
        addRequestProperty("Content-Length", ""+bytes.length);
        return true;
    }
    
    protected void doWriteRequestContent(HttpURLConnection conn) throws IOException
    {
        if (bytes == null || bytes.length == 0)
            return;
        
        conn.getOutputStream().write(bytes);
    }
}
