/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.httpclient;

import java.io.IOException;
import java.net.HttpURLConnection;

import org.zhiqim.kernel.util.Bytes;
import org.zhiqim.kernel.util.Stringx;
import org.zhiqim.kernel.util.Validates;

/**
 * HTTP/HTTPS POST访问类
 * 1.内容以字符串为主，在写入时根据编码格式转换成字节
 * 2.当内容不为空时，必须有mimeType和encoding值
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
public class HttpPost extends HttpClient
{
    private String queryString;
    private String mimeType;
    private String encoding;
    
    public HttpPost(String url)
    {
        super(url, _POST_);
        
        this.mimeType = _APPLICATION_X_WWW_FORM_;
        this.encoding = _UTF_8_;
    }
    
    public void setQueryString(String queryString, String encoding)
    {
        this.queryString = Stringx.trim(queryString);
        this.encoding = Stringx.trim(encoding);
    }
    
    public void setQueryString(String queryString, String mimeType, String encoding)
    {
        this.queryString = Stringx.trim(queryString);
        this.mimeType = Stringx.trim(mimeType);
        this.encoding = Stringx.trim(encoding);
    }
    
    protected boolean doPreRequestProperty()
    {
        if (Validates.isEmpty(queryString))
            return true;
        
        setDoOutput(true);
        addRequestProperty(_CONTENT_TYPE_, mimeType + "; charset="+encoding);
        addRequestProperty(_CONTENT_LENGTH_, ""+Bytes.getByteLen(queryString, encoding));
        return true;
    }
    
    protected void doWriteRequestContent(HttpURLConnection conn) throws IOException
    {
        if (Validates.isEmpty(queryString))
            return;
        
        conn.getOutputStream().write(queryString.getBytes(encoding));
    }
}
