/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.extend;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/**
 * 定义在特定场景创建Map<Class<?>, V>时，无需指定泛型
 *
 * @version v1.0.0 @author zouzhigang 2016-11-15 新建与整理
 */
public abstract class MapCV<V>
{
    protected Map<Class<?>, V> instance;
    
    /***********************************************************/
    //返回Map实例的方法
    /***********************************************************/
    
    /**
     * 返回对应的Map实例
     * 
     * @return          Map实例
     */
    public Map<Class<?>, V> instance()
    {
        return instance;
    }
    
    /***********************************************************/
    //增加&修改&删除Map数据
    /***********************************************************/

    public MapCV<V> putAll(MapCV<V> m)
    {
        instance.putAll(m.instance());
        return this;
    }
    
    public MapCV<V> putAll(Map<Class<?>, V> m)
    {
        instance.putAll(m);
        return this;
    }
    
    public MapCV<V> put(Class<?> key, V value)
    {
        instance.put(key, value);
        return this;
    }
    
    public MapCV<V> clear()
    {
        instance.clear();
        return this;
    }
    
    /***********************************************************/
    //获取Map的数据
    /***********************************************************/

    public V get(Class<?> key)
    {
        return instance.get(key);
    }
    
    public V remove(Class<?> key)
    {
        return instance.remove(key);
    }
    
    public int size()
    {
        return instance.size();
    }
    
    public boolean isEmpty()
    {
        return instance.isEmpty();
    }
    
    public boolean containsKey(Class<?> key)
    {
        return instance.containsKey(key);
    }
    
    public boolean containsValue(Object value)
    {
        return instance.containsValue(value);
    }
    
    public Set<Class<?>> keySet()
    {
        return instance.keySet();
    }
    
    public Collection<V> values()
    {
        return instance.values();
    }
    
    public Set<Map.Entry<Class<?>, V>> entrySet()
    {
        return instance.entrySet();
    }
    
    public String toString()
    {
        return instance.toString();
    }
}
