/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.extend;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/**
 * 定义在特定场景创建Lst<String>时，无需指定泛型
 *
 * @version v1.0.0 @author zouzhigang 2016-11-15 新建与整理
 */
public abstract class ListS implements Iterable<String>
{
    /***********************************************************/
    //返回List实例的方法
    /***********************************************************/
    
    /**
     * 返回对应的List实例
     * 
     * @return          List实例
     */
    public abstract List<String> instance();
    
    /**
     * 从原来的FListS中放置所有的元素到当前FListS
     * 
     * @param list      原有FListS
     * @return          返回自身
     */
    public ListS addAll(ListS list)
    {
        instance().addAll(list.instance());
        return this;
    }

    /***********************************************************/
    //以为实现List的所有方法
    /***********************************************************/
    
    public int size() 
    {
        return instance().size();
    }

    public boolean isEmpty() 
    {
        return instance().isEmpty();
    }

    public boolean contains(String o) 
    {
        return instance().contains(o);
    }
    
    public Iterator<String> iterator() 
    {
        return instance().iterator();
    }

    public String[] toArray() 
    {
        return instance().toArray(new String[0]);
    }
    
    public boolean add(String e) 
    {
        return instance().add(e);
    }

    public boolean remove(String o) 
    {
        return instance().remove(o);
    }
    
    public boolean containsAll(Collection<String> c)
    {
        return instance().containsAll(c);
    }

    public boolean addAll(Collection<String> c) 
    {
        return instance().addAll(c);
    }

    public boolean addAll(int index, Collection<String> c) 
    {
        return instance().addAll(index, c);
    }
    
    public boolean removeAll(Collection<String> c) 
    {
        return instance().removeAll(c);
    }

    public boolean retainAll(Collection<String> c) 
    {
        return instance().retainAll(c);
    }
    
    public void clear() 
    {
        instance().clear();
    }
    
    public String get(int index) 
    {
        return instance().get(index);
    }

    public String set(int index, String element) 
    {
        return instance().set(index, element);
    }
    
    public void add(int index, String element) 
    {
        instance().add(index, element);
    }

    public String remove(int index) 
    {
        return instance().remove(index);
    }

    public int indexOf(String o) 
    {
        return instance().indexOf(o);
    }

    public int lastIndexOf(String o) 
    {
        return instance().lastIndexOf(o);
    }

    public ListIterator<String> listIterator() 
    {
        return instance().listIterator();
    }

    public ListIterator<String> listIterator(int index) 
    {
        return instance().listIterator(index);
    }

    public List<String> subList(int fromIndex, int toIndex) 
    {
        return instance().subList(fromIndex, toIndex);
    }
    
    public String toString()
    {
        return instance().toString();
    }
}
