/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.extend;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;

/**
 * 定义一个LinkedList<Object>对象，在ZML中new时不需要指定泛型
 *
 * @version v1.0.0 @author zouzhigang 2016-10-25 新建与整理
 */
@AnAlias("LinkedListO")
@AnNew
public class LinkedListO extends ListO
{
    private final LinkedList<Object> instance;
    
    public LinkedListO()
    {
        instance = new LinkedList<>();
    }
    
    public LinkedListO(Collection<?> instance)
    {
        this.instance = new LinkedList<>(instance);
    }
    
    public LinkedListO(ListO instance)
    {
        this.instance = new LinkedList<>(instance.instance());
    }
    
    /***********************************************************/
    //实例化
    /***********************************************************/
    
    /**
     * 返回对应的List实例
     * 
     * @return          List实例
     */
    public LinkedList<Object> instance()
    {
        return instance;
    }
    
    /***********************************************************/
    //私有方法
    /***********************************************************/

    public Object getFirst() 
    {
        return instance.getFirst();
    }

    public Object getLast() 
    {
        return instance.getLast();
    }

    public Object removeFirst() 
    {
        return instance.removeFirst();
    }

    public Object removeLast() 
    {
        return instance.removeLast();
    }
    
    public void addFirst(Object e) 
    {
        instance.addFirst(e);
    }

    public void addLast(Object e) 
    {
        instance.addLast(e);
    }
    
    /** @since 1.5 */
    public Object peek() 
    {
        return instance.peek();
    }

    /** @since 1.5 */
    public Object element() 
    {
        return instance.element();
    }

    /** @since 1.5 */
    public Object poll() 
    {
        return instance.poll();
    }

    /** @since 1.5 */
    public Object remove() 
    {
        return instance.remove();
    }

    /** @since 1.5 */
    public boolean offer(Object e) 
    {
        return instance.offer(e);
    }

    /** @since 1.6 */
    public boolean offerFirst(Object e) 
    {
        return instance.offerFirst(e);
    }

    /** @since 1.6 */
    public boolean offerLast(Object e) 
    {
        return instance.offerLast(e);
    }
    
    /** @since 1.6 */
    public Object peekFirst() 
    {
        return instance.peekFirst();
     }

    /** @since 1.6 */
    public Object peekLast() 
    {
        return instance.peekLast();
    }

    /** @since 1.6 */
    public Object pollFirst() 
    {
        return instance.pollFirst();
    }

    /** @since 1.6 */
    public Object pollLast() 
    {
        return instance.pollLast();
    }

    /** @since 1.6 */
    public void push(Object e) 
    {
        instance.push(e);
    }

    /** @since 1.6 */
    public Object pop() 
    {
        return instance.pop();
    }

    /** @since 1.6 */
    public boolean removeFirstOccurrence(Object o) {
        return instance.removeFirstOccurrence(o);
    }

    /** @since 1.6 */
    public boolean removeLastOccurrence(Object o) 
    {
        return instance.removeLastOccurrence(o);
    }
    
    /** @since 1.6 */
    public Iterator<Object> descendingIterator()
    {
        return instance.descendingIterator();
    }

    /***********************************************************/
    //以为实现List的所有方法
    /***********************************************************/
    
    public int size() 
    {
        return instance.size();
    }

    public boolean isEmpty() 
    {
        return instance.isEmpty();
    }

    public boolean contains(Object o) 
    {
        return instance.contains(o);
    }
    
    public Iterator<Object> iterator() 
    {
        return instance.iterator();
    }

    public Object[] toArray() 
    {
        return instance.toArray(new Object[0]);
    }
    
    public <T> T[] toArray(T[] a)
    {
        return instance.toArray(a);
    }
    
    public boolean add(Object e) 
    {
        return instance.add(e);
    }

    public boolean remove(Object o) 
    {
        return instance.remove(o);
    }
    
    public boolean containsAll(Collection<?> c)
    {
        return instance.containsAll(c);
    }

    public boolean addAll(Collection<?> c) 
    {
        return instance.addAll(c);
    }

    public boolean addAll(int index, Collection<?> c) 
    {
        return instance.addAll(index, c);
    }
    
    public boolean removeAll(Collection<?> c) 
    {
        return instance.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) 
    {
        return instance.retainAll(c);
    }
    
    public void clear() 
    {
        instance.clear();
    }
    
    public Object get(int index) 
    {
        return instance.get(index);
    }

    public Object set(int index, Object element) 
    {
        return instance.set(index, element);
    }
    
    public void add(int index, Object element) 
    {
        instance.add(index, element);
    }

    public Object remove(int index) 
    {
        return instance.remove(index);
    }

    public int indexOf(Object o) 
    {
        return instance.indexOf(o);
    }

    public int lastIndexOf(Object o) 
    {
        return instance.lastIndexOf(o);
    }

    public ListIterator<Object> listIterator() 
    {
        return instance.listIterator();
    }

    public ListIterator<Object> listIterator(int index) 
    {
        return instance.listIterator(index);
    }

    public List<Object> subList(int fromIndex, int toIndex) 
    {
        return instance.subList(fromIndex, toIndex);
    }
    
    public String toString()
    {
        return instance.toString();
    }
}
