/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.extend;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;

/**
 * 定义一个HashMap<Class<?>, V>参数和结果对象
 *
 * @version v1.0.0 @author zouzhigang 2016-10-25 新建与整理
 */
@AnAlias("HashMapCV")
@AnNew
public class HashMapCV<V> extends MapCV<V>
{
    /****************************************************************************************************/
    //HashMap
    /****************************************************************************************************/
    
    public HashMapCV()
    {
        this(false);
    }
    
    public HashMapCV(int count)
    {
        this(count, false);
    }
    
    public HashMapCV(Class<?> key, V value)
    {
        this(key, value, false);
    }
    
    public HashMapCV(Map<Class<?>, V> instance)
    {
        this(instance, false);
    }
    
    public HashMapCV(MapCV<V> map)
    {
        this(map, false);
    }
    
    /****************************************************************************************************/
    //ConcurrentHashMap
    /****************************************************************************************************/
    

    public HashMapCV(boolean concurrent)
    {
        if (concurrent)
            instance = new ConcurrentHashMap<>();
        else
            instance = new HashMap<>();
    }
    
    public HashMapCV(int count, boolean concurrent)
    {
        if (concurrent)
            instance = new ConcurrentHashMap<>(count);
        else
            instance = new HashMap<>(count);
    }
    
    public HashMapCV(Class<?> key, V value, boolean concurrent)
    {
        this(concurrent);
        instance.put(key, value);
    }
    
    public HashMapCV(Map<Class<?>, V> instance, boolean concurrent)
    {
        if (concurrent)
            instance = new ConcurrentHashMap<>(instance);
        else
            instance = new HashMap<>(instance);
    }
    
    public HashMapCV(MapCV<V> map, boolean concurrent)
    {
        this(map.instance(), concurrent);
    }
}
