/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.control;

import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.seqs.Sequence;

/**
 * 线程操作者
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
public class Threader extends Threadx implements Runnable
{
    private static final Log log = LogFactory.getLog(Threader.class);
    private static final Sequence sequence = new Sequence();
    
    private final ThreaderController controller;
    private final String threadName;
    
    //线程活动状态
    private volatile boolean isIdle = true;
    private long idleTime = System.currentTimeMillis();
    private long completedCount;
    
    public Threader(ThreaderController controller)
    {
        this.controller = controller;
        this.threadName = controller.getThreadGroup().getName() + "-" + sequence.next();
    }
    
    /**************************************************************************************/
    //线程组&线程名&线程回调循环操作
    /**************************************************************************************/
    
    @Override
    public String getThreadName()
    {
        return threadName;
    }
    
    @Override
    protected ThreadGroup getThreadGroup()
    {
        return controller.getThreadGroup();
    }
    
    @Override
    protected void loop()
    {
        Runnable command = controller.accept();
        if (command == null)
            return;
        
        try
        {
            isIdle = false;
            command.run();
        }
        catch (Exception e)
        {
            log.error("线程池处理时异常：[%s]", e,  e.getMessage());
        }
        finally
        {
            controller.addCompletedCount();
            completedCount++;
            idleTime = System.currentTimeMillis();
            isIdle = true;
            command = null;
        }
    }
    
    /**************************************************************************************/
    //获取运行时属性
    /**************************************************************************************/
    
    public boolean isActive()
    {
        return !isIdle;
    }
    
    public boolean isIdle()
    {
        return isIdle;
    }
    
    public long getIdleTime()
    {
        return idleTime;
    }
    
    public String getIdleTimeString()
    {
        return DateTimes.toDateTimeString(idleTime);
    }
    
    public long getCompletedCount()
    {
        return completedCount;
    }
    
    public boolean isExecessMaxIdleTime(long maxIdleMilliTime)
    {
        return isIdle?(System.currentTimeMillis() - idleTime - maxIdleMilliTime) > 0:false;
    }
}
