/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * 知启蒙微内核（zhiqim_kernel）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.control;

import org.zhiqim.kernel.Service;

/**
 * 实现了线程的服务
 *
 * @ThreadController    线程控制器
 * @HandleController    处理控制器
 * @EventController     事件控制器
 * @version v1.0.0 @author zouzhigang 2018-11-20 新建与整理
 */
public abstract class ThreadServicer extends Threadx implements Service
{
    protected String id;
    protected int index;
    
    /*********************************************************/
    //服务编号和索引引
    /*********************************************************/
    
    /** 设置服务编号,对应conf/zhiqim.xml/service/key */
    public final void setId(String id)
    {
        this.id = id;
    }

    /** 获取服务编号 */
    public final String getId()
    {
        return id;
    }
    
    /** 设置全局变量中多例模式中的索引号 */
    public void setIndex(int index)
    {
        this.index = index;
    }
    
    /** 获取全局变量中多例模式中的索引号 */
    public int getIndex()
    {
        return this.index;
    }
    
    /*********************************************************/
    //服务创建和销毁
    /*********************************************************/
    
    /**
     * 服务创建接口，配置信息从Global中读取，子类必须实现
     * 
     * @return boolean =true,启动成功,=false,启动失败
     */
    public boolean create()
    {
        return open();
    }
    
    /**
     * 服务销毁接口，配置信息从Global中读取，默认不处理，子类可选重写
     * 
     * @throws Exception Hook捕捉,打印日志,异常不处理，直接退出
     */
    public void destroy()
    {
        close();
    }
    
    
    /*********************************************************/
    //更新和测试更新配置
    /*********************************************************/
    
    /**
     * 测试更新配置，默认支持更新配置
     * 
     * @return              =true表示可以更新，=false表示更新可能有问题
     * @throws Exception    异常时表示不可更新
     */
    public boolean test() throws Exception
    {
        return false;
    }
    
    /**
     * 服务更新配置，默认不处理更新配置
     * 
     * @throws Exception 出现更新异常通知配置端
     */
    public void update() throws Exception
    {
    }
}
