/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.zhiqim.kernel.extend.HashMapCV;
import org.zhiqim.kernel.extend.MapCV;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Randoms;

/**
 * 事件处理线程池控制器，指定池最小值、最大值、初始值，允许线程空闲时长和允许缓存对象大小<br><br>
 * 1.创建时创建初始值大小的线程池，创建对象队列，和主线程<br>
 * 2.其他线程通过post传递对象可执行对象<br>
 * 3.主线程调度线程池处理对象，并检查线程池空闲线程
 * 4.每个事件支持多个事件处理器处理，其中某个事件处理器return=false表示终止事件处理,return=true表示继续处理
 *
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
public class EventerController extends ThreaderController
{
    private static final Log log = LogFactory.getLog(EventerController.class);
    private final MapCV<List<Eventer<?>>> eventerMap = new HashMapCV<List<Eventer<?>>>();
    
    public EventerController()
    {
        setThreadName("Eventer-" + Randoms.upperLetters(1)+Randoms.lowerLettersDigits(3));
    }
    
    @Override
    public void closeAfter()
    {
        super.closeAfter();
        eventerMap.clear();
    }
    
    /** 增加一个对象处理器 */
    public void addEventer(Eventer<?> eventer)
    {
        Class<?> clazz = eventer.clazz();
        List<Eventer<?>> list = eventerMap.get(clazz);
        if (list == null)
        {
            list = new ArrayList<Eventer<?>>();
            eventerMap.put(clazz, list);
        }
        
        list.add(eventer);
    }

    /** 删除一个对象处理器 */
    public void removeEventer(Eventer<?> eventer)
    {
        Class<?> clazz = eventer.clazz();
        List<Eventer<?>> list = eventerMap.get(clazz);
        if (list == null)
            return;
        
        for (Iterator<Eventer<?>> it=list.iterator();it.hasNext();)
        {
            Eventer<?> item = it.next();
            if (item.getClass() == eventer.getClass())
                it.remove();
        }
        
        //如果删除后没有，则删除事件处理索引，认为该事件以后由缺省处理
        if (list.isEmpty())
            eventerMap.remove(clazz);
    }
    
    /** 处理一个对象，转化为HandlerRunnable由父类处理 */
    public boolean execute(Object event)
    {
        return execute(event, false);
    }
    
    /** 处理一个对象，转化为HandlerRunnable由父类处理 */
    public boolean execute(Object event, boolean priority)
    {
        List<Eventer<?>> eventer = eventerMap.get(event.getClass());
        if (eventer == null)
        {
            log.fatal("事件处理器[%s]未配置处理器", event.getClass().getName());
            return false;
        }
        
        @SuppressWarnings({ "rawtypes", "unchecked" })
        Eventee<?> command = new Eventee(event, eventer);
        return super.execute(command, priority);
    }
}
