/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.constants;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.CodeConstants;

/**
 * 常用HTTP常量定义，并继承编码常量和符号常量定义
 *
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("HttpConstants")
public interface HttpConstants extends CodeConstants, HtmlConstants
{
    //常用的mimeType
    public String _TEXT_HTML_                          = "text/html";
    public String _TEXT_HTML_UTF_8_                    = "text/html; charset=UTF-8";
    public String _TEXT_PLAIN_                         = "text/plain";
    public String _TEXT_PLAIN_UTF_8_                   = "text/plain; charset=UTF-8";
    public String _TEXT_CDP_                           = "text/x-cross-domain-policy";
    public String _APPLICATION_XML_                    = "application/xml";
    public String _APPLICATION_X_WWW_FORM_             = "application/x-www-form-urlencoded";
    public String _APPLICATION_X_WWW_FORM_UTF_8_       = "application/x-www-form-urlencoded; charset=UTF-8";
    public String _APPLICATION_OCTET_STREAM_           = "application/octet-stream";
    public String _MULTIPART_FORM_DATA_                = "multipart/form-data";

    //常用的协议
    public String _HTTP_                               = "http";
    public String _HTTPS_                              = "https";
    public String _HTTP_1_0_                           = "HTTP/1.0";//支持1.0
    public String _HTTP_1_1_                           = "HTTP/1.1";//支持1.1
    
    //常用的方法
    public String _GET_                                = "GET";//获取资源
    public String _POST_                               = "POST";//提交资源
    public String _HEAD_                               = "HEAD";//验证资源
    public String _PUT_                                = "PUT";//增加资源，和DELETE成对使用
    public String _DELETE_                             = "DELETE";//删除资源，和PUT成对使用
    
    //常用的状态码
    //0: 表示绝对成功
    //7x-9x: 表示客户端请求失败
    //1xx：指示信息--表示请求已接收，继续处理
    //2xx：成功--表示请求已被成功接收、理解、接受
    //3xx：重定向--要完成请求必须进行更进一步的操作
    //4xx：客户端错误--请求有语法错误或请求无法实现
    //5xx：服务器端错误--服务器未能实现合法的请求
    //6xx: 大于600的状态码由框架定义
    public int _0_SUCCESS_                             = 0;//0 Success //绝对成功
    public int _70_MALFORMED_URL_                      = 70;//70 Malformed URL //非法的URL
    public int _71_UNKOWN_HOST_                        = 71;//71 Unkown Host //未知的主机地址
    public int _72_PARAM_NOT_SATISFIED_                = 72;//72 Param Not Satisfied //参数未满足
    public int _73_SOCKET_TIMEOUT_                     = 73;//73 Socket Timeout //Socket 超时
    public int _80_SSL_EXCEPTION_                      = 80;//80 SSL Exception //SSL 异常
    public int _81_SSL_HANDSHAKE_EXCEPTION_            = 81;//81 SSL Handshake Exception //SSL 握手异常
    public int _90_SOCKET_EXCEPTION_                   = 90;//90 Socket Exception //Socket 异常
    public int _91_CONNECT_EXCEPTION_                  = 91;//90 Connect Exception //连接异常
    public int _98_IO_EXCEPTION_                       = 98;//98 IO Exception //IO异常
    public int _99_EXCEPTION_                          = 99;//99 Exception //未知异常
    
    public int _100_CONTINUE_                          = 100;//100 Continue //客户端应当继续发送请求
    public int _101_SWITCHING_PROTOCOLS_               = 101;//101 Switching Protocols //服务器将遵从客户的请求转换到另外一种协议 
    public int _102_PROCESSING_                        = 102;//102 Processing //由WebDAV（RFC 2518）扩展的状态码，代表处理将被继续执行。
    public int _200_OK_                                = 200;//200 OK //客户端请求成功
    public int _201_CREATED_                           = 201;//201 Created //服务器已经创建了文档，Location头给出了它的URL。 一般应用于PUT请求时
    public int _202_ACCEPTED_                          = 202;//202 Accepted //服务器已接受请求，文档还未处理完，一般应用于PUT请求异步处理
    public int _203_NON_AUTHORITATIVE_INFORMATION_     = 203;//203 Non-Authoritative Information 文档已经正常地返回，但一些应答头可能不正确，因为使用的是文档的拷贝，一般应用于PUT秒传。
    public int _204_NO_CONTENT_                        = 204;//204 No Content //客户端请求成功，无内容，和200内容为空不同的是，200浏览器会跳转到空页面，而204是忽略，即不跳转
    public int _205_RESET_CONTENT_                     = 205;//205 Reset Content //服务器成功处理了请求,和204不同的是205要求重置内容，如刷新或重置表单等
    public int _206_PARTIAL_CONTENT_                   = 206;//206 Partial Content //客户端请求成功，响应部分内容，一般用于断点续传，客户端指定Range,服务端相应Range部分的内容
    public int _207_MULTI_STATUS_                      = 207;//207 Multi-Status //由WebDAV(RFC 2518)扩展的状态码，代表之后的消息体将是一个XML消息，并且可能依照之前子请求数量的不同，包含一系列独立的响应代码。
    public int _300_MULTIPLE_CHOICES_                  = 300;//300 Multiple Choices 客户请求的文档可以在多个位置找到，这些位置已经在返回的文档内列出。如果服务器要提出优先选择，则应该在Location应答头指明。 
    public int _301_MOVED_PERMANENTLY_                 = 301;//301 Moved Permanently //所请求的页面已经转移至新的url。
    public int _302_FOUND_                             = 302;//302 FOUND //客户端重定向，GET/POST都重定向
    public int _303_SEE_OTHER_                         = 303;//303 See Other //所请求的页面可在别的url下被找到。
    public int _304_NOT_MODIFIED_                      = 304;//304 Not Modified //内容未修改
    public int _305_USE_PROXY_                         = 305;//305 Use Proxy 客户请求的文档应该通过Location头所指明的代理服务器提取。 
    public int _306_SWITCH_PROXY_                      = 306;//306 Switch Proxy在最新版的规范中，306状态码已经不再被使用。
    public int _307_TEMPORARY_REDIRECT_                = 307;//307 Temporary Redirect 和302（Found）相同，但只作GET重定向。 
    public int _400_BAD_REQUEST_                       = 400;//400 Bad Request //客户端请求有语法错误，不能被服务器所理解
    public int _401_UNAUTHORIZED_                      = 401;//401 Unauthorized //请求未经授权，这个状态代码必须和WWW-Authenticate报头域一起使用 
    public int _402_PAYMENT_REQUIRED_                  = 402;//402 Payment Required 该状态码是为了将来可能的需求而预留的。
    public int _403_FORBIDDEN_                         = 403;//403 Forbidden  //服务器收到请求，但是拒绝提供服务
    public int _404_NOT_FOUND_                         = 404;//404 Not Found  //请求资源不存在，eg：输入了错误的URL
    public int _405_METHOD_NOT_ALLOWD_                 = 405;//405 Method Not Allow //方法不支持
    public int _406_NOT_ACCEPTABLE_                    = 406;//406 Not Acceptable //指定的资源已经找到，但它的MIME类型和客户在Accpet头中所指定的不兼容。 
    public int _407_PROXY_AUTHENTICATION_REQUIRED_     = 407;//407 Proxy Authentication Required 类似于401，表示客户必须先经过代理服务器的授权。
    public int _408_REQUEST_TIMEOUT_                   = 408;//408 Request Timeout 在服务器许可的等待时间内，客户一直没有发出任何请求。客户可以在以后重复同一请求。
    public int _409_CONFLICT_                          = 409;//409 Conflict 通常和PUT请求有关。由于请求和资源的当前状态相冲突，因此请求不能成功。
    public int _410_GONE_                              = 410;//410 Gone 所请求的文档已经不再可用，而且服务器不知道应该重定向到哪一个地址。它和404的不同在于，返回407表示文档永久地离开了指定的位置，而404表示由于未知的原因文档不可用。
    public int _411_LENGTH_REQUIRED_                   = 411;//411 Length Required //内容长度必须提供
    public int _412_PRECONDITION_FAILED_               = 412;//412 Precondition Failed 请求头中指定的一些前提条件失败。 
    public int _413_REQUEST_ENTITY_TOO_LARGE_          = 413;//413 Request Entity Too Large //请求的实体太大
    public int _414_REQUEST_URL_TOO_LARGE_             = 414;//414 Request Url Too Large //请求URL太大
    public int _415_UNSUPPORTED_MEDIA_TYPE_            = 415;//415 Unsupported Media Type 对于当前请求的方法和所请求的资源，请求中提交的实体并不是服务器中所支持的格式，因此请求被拒绝。
    public int _416_REQUESTED_RANGE_NOT_SATISFIABLE_   = 416;//416 Requested Range Not Satisfiable 服务器不能满足客户在请求中指定的Range头
    public int _417_EXPECTATION_FAILED_                = 417;//417 Expectation Failed在请求头 Expect 中指定的预期内容无法被服务器满足。
    public int _421_TOO_MANY_CONNECTIONS_FROM_IP_      = 421;//421 There are too many connections from your internet address 从当前客户端所在的IP地址到服务器的连接数超过了服务器许可的最大范围。
    public int _422_UNPROCESSABLE_ENTITY_              = 422;//422 Unprocessable Entity 请求格式正确，但是由于含有语义错误，无法响应。（RFC 4918 WebDAV）
    public int _423_LOCKED_                            = 423;//423 Locked 当前资源被锁定。（RFC 4918 WebDAV）
    public int _424_FAILED_DEPENDENCY_                 = 424;//424 Failed Dependency 由于之前的某个请求发生的错误，导致当前请求失败，例如 PROPPATCH。（RFC 4918 WebDAV）
    public int _425_UNORDERED_COLLECTION_              = 425;//425 Unordered Collection 在WebDav Advanced Collections 草案中定义，但是未出现在《WebDAV 顺序集协议》（RFC 3658）中。
    public int _426_UPGRADE_REQUIRED_                  = 426;//426 Upgrade Required 客户端应当切换到TLS/1.0。（RFC 2817）
    public int _444_INTERRUPT_                         = 444;//444 Interrupt //直接中断,NGINX使用到
    public int _449_RETRY_WITH_                        = 449;//449 Retry With //重试,微软使用到
    public int _500_INTERNAL_SERVER_ERROR_             = 500;//500 Internal Server Error //服务器发生不可预期的错误
    public int _501_NOT_IMPLEMENTED_                   = 501;//501 Not Implemented 服务器不支持实现请求所需要的功能。例如，客户发出了一个服务器不支持的PUT请求。 
    public int _502_BAD_GATEWAY_                       = 502;//502 Bad Gateway 作为网关或者代理工作的服务器尝试执行请求时，从上游服务器接收到无效的响应。
    public int _503_SERVER_UNAVAILABLE_                = 503;//503 Server Unavailable  //服务器当前不能处理客户端的请求，一段时间后可能恢复正常
    public int _504_GATEWAY_TIMEOUT_                   = 504;//504 Gateway Timeout 由作为代理或网关的服务器使用，表示不能及时地从远程服务器获得应答。
    public int _505_VERSION_NOT_SUPPORTED_             = 505;//505 HTTP Version Not Supported //服务器不支持版本
    public int _506_VARIANT_ALSO_NEGOTIATES_           = 506;//506 Variant Also Negotiates 由《透明内容协商协议》（RFC 2295）扩展，代表服务器存在内部配置错误：被请求的协商变元资源被配置为在透明内容协商中使用自己，因此在一个协商处理中不是一个合适的重点。
    public int _507_INSUFFICIENT_STORAGE_              = 507;//507 Insufficient Storage 服务器无法存储完成请求所必须的内容。这个状况被认为是临时的。WebDAV (RFC 4918)
    public int _508_LOOP_DETECTED_                     = 508;//508 Loop Detected 服务器发现请求中出现一个无穷循环
    public int _509_BANDWIDTH_LIMIT_EXCEEDED_          = 509;//509 Bandwidth Limit Exceeded 服务器达到带宽限制。这不是一个官方的状态码，但是仍被广泛使用。
    public int _510_NOT_EXTENDED_                      = 510;//510 Not Extended 服务器不支持的扩展。（RFC 2774）
    public int _600_UNPARSEABLE_RESPONSE_HEADERS_      = 600;//600 Unparseable Response Headers //无法解析响应头

    public int _601_REDIRECT_PARENT_                   = 601;//601 Redirect Parent //重定向到父页
    public int _602_REDIRECT_                          = 602;//602 Redirect //重定向
    public int _603_REDIRECT_TOP_                      = 603;//603 Redirect Top //重定向到顶页
    public int _611_IP_NOT_ALLOW_                      = 611;//601 Ip Not Allow //IP鉴权失败
    public int _612_SIGNATURE_FAILED_                  = 612;//602 Signature failed //签名验证失败
    public int _621_INTERCEPTOR_NOT_EXIST_             = 621;//611 Interceptor Not Exist //拦截器不存在
    public int _622_INTERCEPTED_                       = 622;//612 Intercepted //被拦截
    public int _623_INTERCEPTOR_EXCEPTION_             = 623;//613 Interceptor Exception //拦截器异常
    public int _699_ERROR_                             = 699;//699 Error //通用错误
    
    public String _0_DESC_                             = "Success";//0 Success //绝对成功
    public String _70_DESC_                            = "Malformed URL";//70 Malformed URL //非法的URL
    public String _71_DESC_                            = "Unkown Host";//71 Unkown Host //未知的主机地址
    public String _72_DESC_                            = "Param Not Satisfied";//72 //参数未满足
    public String _73_DESC_                            = "Socket Timeout";//73 Socket Timeout //Socket 超时
    public String _80_DESC_                            = "SSL Exception";//80 SSL Exception //SSL 异常
    public String _81_DESC_                            = "SSL Handshake Exception";//81 SSL Handshake Exception //SSL 握手异常
    public String _90_DESC_                            = "Socket Exception";//90 Socket Exception //Socket 异常
    public String _91_DESC_                            = "Connect Exception";//91 Connect Exception //连接异常
    public String _98_DESC_                            = "IO Exception";//98 IO Exception //未知IO异常
    public String _99_DESC_                            = "Exception";//99 Exception //未知异常
   
    public String _100_DESC_                           = "Continue";//100 Continue //客户端应当继续发送请求（HTTP 1.1新）
    public String _101_DESC_                           = "Switching Protocols";//101 Switching Protocols //服务器将遵从客户的请求转换到另外一种协议（HTTP 1.1新） 
    public String _102_DESC_                           = "Processing";//102 Processing //由WebDAV（RFC 2518）扩展的状态码，代表处理将被继续执行。
    public String _200_DESC_                           = "OK";//200 OK //客户端请求成功
    public String _201_DESC_                           = "Created";//201 Created //服务器已经创建了文档，Location头给出了它的URL。 一般应用于PUT请求时
    public String _202_DESC_                           = "Accepted";//202 Accepted //服务器已接受请求，文档还未处理完，一般应用于PUT请求异步处理
    public String _203_DESC_                           = "Non-Authoritative Information";//203 Non-Authoritative Information 文档已经正常地返回，但一些应答头可能不正确，因为使用的是文档的拷贝，一般应用于PUT秒传。
    public String _204_DESC_                           = "No Content";//204 No Content //客户端请求成功，无内容，和200内容为空不同的是，200浏览器会跳转到空页面，而204是忽略，即不跳转
    public String _205_DESC_                           = "Reset Content";//205 Reset Content //服务器成功处理了请求,和204不同的是205要求重置内容，如刷新或重置表单等
    public String _206_DESC_                           = "Partial Content";//206 Partial Content //客户端请求成功，响应部分内容，一般用于断点续传，客户端指定Range,服务端相应Range部分的内容
    public String _207_DESC_                           = "Multi-Status";//207 Multi-Status //由WebDAV(RFC 2518)扩展的状态码，代表之后的消息体将是一个XML消息，并且可能依照之前子请求数量的不同，包含一系列独立的响应代码。
    public String _300_DESC_                           = "Multiple Choices";//301 Moved Permanently //所请求的页面已经转移至新的url。
    public String _301_DESC_                           = "Moved Permanently";//301 Moved Permanently //所请求的页面已经转移至新的url。
    public String _302_DESC_                           = "FOUND";//302 FOUND //客户端重定向
    public String _303_DESC_                           = "See Other";//303 See Other //所请求的页面可在别的url下被找到。
    public String _304_DESC_                           = "Not Modified";//304 Not Modified //内容未修改
    public String _305_DESC_                           = "Use Proxy";//305 Use Proxy 客户请求的文档应该通过Location头所指明的代理服务器提取。 
    public String _306_DESC_                           = "Switch Proxy";//306 Switch Proxy在最新版的规范中，306状态码已经不再被使用。
    public String _307_DESC_                           = "Temporary Redirect";//307 Temporary Redirect 和302（Found）相同，但只作GET重定向。 
    public String _400_DESC_                           = "Bad Request";//400 Bad Request //客户端请求有语法错误，不能被服务器所理解
    public String _401_DESC_                           = "Unauthorized";//401 Unauthorized //请求未经授权，这个状态代码必须和WWW-Authenticate报头域一起使用 
    public String _402_DESC_                           = "Payment Required";//402 Payment Required 该状态码是为了将来可能的需求而预留的。
    public String _403_DESC_                           = "Forbidden";//403 Forbidden  //服务器收到请求，但是拒绝提供服务
    public String _404_DESC_                           = "Not Found";//404 Not Found  //请求资源不存在，eg：输入了错误的URL
    public String _405_DESC_                           = "Method Not Allow";//405 Method Not Allow //内容长度必须提供
    public String _406_DESC_                           = "Not Acceptable";//406 Not Acceptable //指定的资源已经找到，但它的MIME类型和客户在Accpet头中所指定的不兼容。 
    public String _407_DESC_                           = "Proxy Authentication Required";//407 Proxy Authentication Required 类似于401，表示客户必须先经过代理服务器的授权。
    public String _408_DESC_                           = "Request Timeout";//408 Request Timeout 在服务器许可的等待时间内，客户一直没有发出任何请求。客户可以在以后重复同一请求。
    public String _409_DESC_                           = "Conflict";//409 Conflict 通常和PUT请求有关。由于请求和资源的当前状态相冲突，因此请求不能成功。
    public String _410_DESC_                           = "Gone";//410 Gone 所请求的文档已经不再可用，而且服务器不知道应该重定向到哪一个地址。它和404的不同在于，返回407表示文档永久地离开了指定的位置，而404表示由于未知的原因文档不可用。
    public String _411_DESC_                           = "Length Required";//411 Length Required //内容长度必须提供
    public String _412_DESC_                           = "Precondition Failed";//412 Precondition Failed 请求头中指定的一些前提条件失败。 
    public String _413_DESC_                           = "Request Entity Too Large";//413 Request Entity Too Large //请求的实体太大
    public String _414_DESC_                           = "Request Url Too Large";//414 Request Url Too Large //请求URL太大
    public String _415_DESC_                           = "Unsupported Media Type";//415 Unsupported Media Type 对于当前请求的方法和所请求的资源，请求中提交的实体并不是服务器中所支持的格式，因此请求被拒绝。
    public String _416_DESC_                           = "Requested Range Not Satisfiable";//416 Requested Range Not Satisfiable 服务器不能满足客户在请求中指定的Range头
    public String _417_DESC_                           = "Expectation Failed";//417 Expectation Failed在请求头 Expect 中指定的预期内容无法被服务器满足。
    public String _421_DESC_                           = "There are too many connections from your internet address";//421 There are too many connections from your internet address 从当前客户端所在的IP地址到服务器的连接数超过了服务器许可的最大范围。
    public String _422_DESC_                           = "Unprocessable Entity";//422 Unprocessable Entity 请求格式正确，但是由于含有语义错误，无法响应。（RFC 4918 WebDAV）
    public String _423_DESC_                           = "Locked";//423 Locked 当前资源被锁定。（RFC 4918 WebDAV）
    public String _424_DESC_                           = "Failed Dependency";//424 Failed Dependency 由于之前的某个请求发生的错误，导致当前请求失败，例如 PROPPATCH。（RFC 4918 WebDAV）
    public String _425_DESC_                           = "Unordered Collection";//425 Unordered Collection 在WebDav Advanced Collections 草案中定义，但是未出现在《WebDAV 顺序集协议》（RFC 3658）中。
    public String _426_DESC_                           = "Upgrade Required";//426 Upgrade Required 客户端应当切换到TLS/1.0。（RFC 2817）
    public String _444_DESC_                           = "Interrupt";//444 Interrupt //直接中断,NGINX使用到
    public String _449_DESC_                           = "Retry With";//449 Retry With //重试,微软使用到
    public String _500_DESC_                           = "Internal Server Error";//500 Internal Server Error //服务器发生不可预期的错误
    public String _501_DESC_                           = "Not Implemented";//501 Not Implemented 服务器不支持实现请求所需要的功能。例如，客户发出了一个服务器不支持的PUT请求。 
    public String _502_DESC_                           = "Bad Gateway";//502 Bad Gateway 作为网关或者代理工作的服务器尝试执行请求时，从上游服务器接收到无效的响应。
    public String _503_DESC_                           = "Server Unavailable";//503 Server Unavailable  //服务器当前不能处理客户端的请求，一段时间后可能恢复正常
    public String _504_DESC_                           = "Gateway Timeout";//504 Gateway Timeout 由作为代理或网关的服务器使用，表示不能及时地从远程服务器获得应答
    public String _505_DESC_                           = "HTTP Version Not Supported";//505 HTTP Version Not Supported //服务器不支持版本
    public String _506_DESC_                           = "Variant Also Negotiates";//506 Variant Also Negotiates 由《透明内容协商协议》（RFC 2295）扩展，代表服务器存在内部配置错误：被请求的协商变元资源被配置为在透明内容协商中使用自己，因此在一个协商处理中不是一个合适的重点。
    public String _507_DESC_                           = "Insufficient Storage";//507 Insufficient Storage 服务器无法存储完成请求所必须的内容。这个状况被认为是临时的。WebDAV (RFC 4918)
    public String _508_DESC_                           = "Loop Detected";//508 Loop Detected 服务器发现请求中出现一个无穷循环
    public String _509_DESC_                           = "Bandwidth Limit Exceeded";//509 Bandwidth Limit Exceeded 服务器达到带宽限制。这不是一个官方的状态码，但是仍被广泛使用。
    public String _510_DESC_                           = "Not Extended";//510 Not Extended 服务器不支持的扩展。（RFC 2774）
    public String _600_DESC_                           = "Unparseable Response Headers";//600 Unparseable Response Headers //无法解析响应头
    
    public String _601_DESC_                           = "Redirect Parent";//601 Redirect Parent //重定向到父页
    public String _602_DESC_                           = "Redirect";//602 Redirect //重定向
    public String _603_DESC_                           = "Redirect Top";//603 Redirect Top //重定向到顶页
    public String _611_DESC_                           = "IP Not Allow";//611 IP Not Allow //IP鉴权失败
    public String _612_DESC_                           = "Signature failed";//612 Business Error //签名验证失败
    public String _621_DESC_                           = "Interceptor Not Exist";//621 Interceptor Not Exist //拦截器不存在
    public String _622_DESC_                           = "Intercepted";//622 Intercepted //被拦截
    public String _623_DESC_                           = "Interceptor Exception";//623 Interceptor Exception //拦截器异常
    public String _699_DESC_                           = "Error";//699 Error 通用错误
    
    //常用的证书报文域和存储域
    public String _SSL_CERT_                           = "SSL_CERT";
    public String _SSL_CERTS_KEY_                      = "java.security.cert.X509Certificate";//把证书放置context，以便业务验证
    
    //常用的一般报文域
    public String _DATE_                               = "Date";//消息产生的日期和时间
    public String _CACHE_CONTROL_                      = "Cache-Control";//用于指定缓存指令，缓存指令是单向的（响应中出现的缓存指令在请求中未必会出现），且是独立的（一个消息的缓存指令不会影响另一个消息处理的缓存机制），
    public String _PRAGMA_                             = "Pragma";//HTTP1.0使用的类似于Cache-Control报头域为Pragma
    public String _P3P_                                = "P3P";//Platform for Privacy Preferences
    public String _CONNECTION_                         = "Connection";//连接属性keep-alive等
    
    //常用的请求报文域
    public String _ACCEPT_                             = "Accept";//Accept请求报头域用于指定客户端接受哪些类型的信息。eg：Accept：image/gif，表明客户端希望接受GIF图象格式的资源；Accept：text/html，表明客户端希望接受html文本。
    public String _ACCEPT_CHARSET_                     = "Accept-Charset";//请求报头域用于指定客户端接受的字符集。eg：Accept-Charset:iso-8859-1,gb2312.如果在请求消息中没有设置这个域，缺省是任何字符集都可以接受。
    public String _ACCEPT_ENCODING_                    = "Accept-Encoding";//请求报头域类似于Accept，但是它是用于指定可接受的内容编码。eg：Accept-Encoding:gzip.deflate.如果请求消息中没有设置这个域服务器假定客户端对各种内容编码都可以接受。
    public String _ACCEPT_LANGUAGE_                    = "Accept-Language";//请求报头域类似于Accept，但是它是用于指定一种自然语言。eg：Accept-Language:zh-cn.如果请求消息中没有设置这个报头域，服务器假定客户端对各种语言都可以接受
    public String _AUTHORIZATION_                      = "Authorization";//主要用于证明客户端有权查看某个资源。当浏览器访问一个页面时，如果收到服务器的响应代码为401（未授权），可以发送一个包含Authorization请求报头域的请求，要求服务器对其进行验证。
    public String _HOST_                               = "Host";//用于指定被请求资源的Internet主机和端口号，它通常从HTTP URL中提取出来的，eg：我们在浏览器中输入：http://WWW.GONUP.ORG/index.html
    public String _USER_AGENT_                         = "User-Agent";//User-Agent请求报头域允许客户端将它的操作系统、浏览器和其它属性告诉服务器。不过，这个报头域不是必需的，如果我们自己编写一个浏览器，不使用User-Agent请求报头域，那么服务器端就无法得知我们的信息了。
    public String _IF_MODIFIED_SINCE_                  = "If-Modified-Since";//修改条件
    public String _REFERER_                            = "Referer";//访问来源
    public String _RANGE_                              = "Range";//请求范围，当前仅支持bytes
    
    
    //常用的请求代理头
    public String _X_FORWARDED_HOST_                   = "X-Forwarded-Host";
    public String _X_FORWARDED_SERVER_                 = "X-Forwarded-Server";
    public String _X_FORWARDED_FOR_                    = "X-Forwarded-For";
    public String _X_FORWARDED_PROTO_                  = "X-Forwarded-Proto";
    
    //常用的定义请求来源和响应方式
    public String _X_REQUESTED_WITH_                   = "X-Requested-With";
    public String _X_RESPONSED_MODE_                   = "X-Responsed-Mode";
    
    //常用的远程方法调用请求头
    public String _X_RMI_KEY_                          = "X-RMI-Key";
    public String _X_RMI_CLASS_                        = "X-RMI-Class";
    public String _X_RMI_METHOD_                       = "X-RMI-Method";
    public String _X_RMI_SERVICE_                      = "X-RMI-Service";
    public String _X_RMI_TIMESTAMP_                    = "X-RMI-Timestamp";
    public String _X_RMI_AUTHORIZATION_                = "X-RMI-Authorization";
    
    //常用的上传组件请求头
    public String _X_UPLOAD_FILE_ID_                   = "X-Upload-File-Id";
    public String _X_UPLOAD_FILE_DIR_                  = "X-Upload-File-Dir";
    public String _X_UPLOAD_FILE_NAME_                 = "X-Upload-File-Name";
    public String _X_UPLOAD_FILE_MD5_                  = "X-Upload-File-Md5";
    public String _X_UPLOAD_FILE_MD5_TARGET_           = "X-Upload-File-Md5-Target";
    public String _X_UPLOAD_FILE_LENGTH_               = "X-Upload-File-Length";
    public String _X_UPLOAD_FILE_URL_                  = "X-Upload-File-Url";
    public String _X_UPLOAD_CHUNK_NUM_                 = "X-Upload-Chunk-Num";
    public String _X_UPLOAD_CHUNK_SIZE_                = "X-Upload-Chunk-Size";
    public String _X_UPLOAD_CHUNK_NO_                  = "X-Upload-Chunk-No";
    
    //常用的响应报文域
    public String _LOCATION_                           = "Location";//用于重定向接受者到一个新的位置。Location响应报头域常用在更换域名的时候。
    public String _SERVER_                             = "Server";//包含了服务器用来处理请求的软件信息。与User-Agent请求报头域是相对应的,如：Server：Apache-Coyote/1.1
    public String _WWW_AUTHENTICATE_                   = "WWW-Authenticate";//必须被包含在401（未授权的）响应消息中，客户端收到401响应消息时候，并发送Authorization报头域请求服务器对其进行验证时，服务端响应报头就包含该报头域。eg：WWW-Authenticate:Basic realm="Basic Auth Test!"  //可以看出服务器对请求资源采用的是基本验证机制。
    public String _ALLOW_                              = "Allow";//支持的方法 和405一起使用
    public String _ACCEPT_RANGES_                      = "Accept-Ranges";//接受范围
    public String _PROXY_CONNECTION_                   = "Proxy-Connection";//代理连接
    
    //常用的实体报文域
    public String _CONTENT_DISPOSITION_                = "Content-Disposition";//文件类型和文件名
    public String _CONTENT_ENCODING_                   = "Content-Encoding";//它的值指示了已经被应用到实体正文的附加内容的编码，因而要获得Content-Type报头域中所引用的媒体类型，必须采用相应的解码机制。Content-Encoding这样用于记录文档的压缩方法，eg：Content-Encoding：gzip
    public String _CONTENT_LANGUAGE_                   = "Content-Language";//描述了资源所用的自然语言。没有设置该域则认为实体内容将提供给所有的语言阅读者。eg：Content-Language:da
    public String _CONTENT_LENGTH_                     = "Content-Length";//用于指明实体正文的长度，以字节方式存储的十进制数字来表示。
    public String _CONTENT_TYPE_                       = "Content-Type";//指明发送给接收者的实体正文的媒体类型。eg：Content-Type:text/html;charset=ISO-8859-1,Content-Type:text/html;charset=GB2312
    public String _CONTENT_LOCATION_                   = "Content-Location";
    public String _EXPIRES_                            = "Expires";//实体报头域给出响应过期的日期和时间。为了让代理服务器或浏览器在一段时间以后更新缓存中(再次访问曾访问过的页面时，直接从缓存中加载，缩短响应时间和降低服务器负载)的页面，我们可以使用Expires实体报头域指定页面过期的时间。eg：Expires：Thu，15 Sep 2006 16:23:12 GMT HTTP1.1的客户端和缓存必须将其他非法的日期格式（包括0）看作已经过期。eg：为了让浏览器不要缓存页面，我们也可以利用Expires实体报头域，设置为0，jsp中程序如下：response.setDateHeader("Expires","0");
    public String _LAST_MODIFIED_                      = "Last-Modified";//用于指示资源的最后修改日期和时间。
    public String _TRANSFER_ENCODING_                  = "Transfer-Encoding";//表示输出的内容长度不能确定，如Transfer-Encoding:chunked表示分块传输
    
    //Cookie响应报文域
    public String _COOKIE_                             = "Cookie";//版本0适用
    public String _COOKIE2_                            = "Cookie2";//版本1适用
    public String _SET_COOKIE_                         = "Set-Cookie";//版本0适用
    public String _SET_COOKIE2_                        = "Set-Cookie2";//版本1适用
    public String _COOKIE_VERSION_                     = "Version";//版本，当前统一使用Version=1，原版本Version=0
    public String _COOKIE_MAX_AGE_                     = "Max-Age";//版本1适用
    public String _COOKIE_DISCARD_                     = "Discard";//版本1适用
    public String _COOKIE_DOMAIN_                      = "Domain";//版本0适用
    public String _COOKIE_PORT_                        = "Port";//版本1适用
    public String _COOKIE_PATH_                        = "Path";//版本0适用
    public String _COOKIE_SECURE_                      = "Secure";//SSL时才传送
    public String _COOKIE_HTTP_ONLY                    = "HttpOnly";//IE首先增加，后续的浏览器都支持
    
    //WebSocket报文域
    public String _UPGRADE_                            = "Upgrade";
    public String _WEBSOCKET_                          = "WebSocket";
    public String _WEBSOCKET_SALT_                     = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    public String _SEC_WEBSOCKET_KEY_                  = "Sec-WebSocket-Key";
    public String _SEC_WEBSOCKET_PROTOCOL_             = "Sec-WebSocket-Protocol";
    public String _SEC_WEBSOCKET_VERSION_              = "Sec-WebSocket-Version";
    public String _SEC_WEBSOCKET_ACCEPT_               = "Sec-WebSocket-Accept";
    
    //常用的报文域内容
    public String _CLOSE_                              = "close";
    public String _KEEP_ALIVE_                         = "keep-alive";
    public String _JSESSIONID_                         = "jsessionid";
    public String _BYTES_                              = "bytes";
    public String _ENCODING_GZIP_                      = "gzip";
    public String _CHUNKED_                            = "chunked";
    public String _NO_CACHE_                           = "no-cache";
    public String _NO_CACHE_MUST_RV_NO_STORE_          = "no-cache, must-revalidate, no-store";
    public String _MAX_AGE_                            = "max-age";
    public String _MAX_AGE_3600_                       = "max-age=3600";
    public String _MAX_AGE_600_                        = "max-age=600";
    public String _MAX_AGE_1_                          = "max-age=1";
    public String _PRIVATE_                            = "private";
    public String _PUBLIC_                             = "public";
    public String _P3P_CP_CAO_PSA_OUR_                 = "CP=\"CAO PSA OUR\"";//IFRAME 在IE6以后增加了隐藏cookie不发送的安全机制P3P，本句表示允许第三方cookie的读写IE6//CAO -  contact-and-other
    public String _XML_HTTP_REQUEST_                   = "XMLHttpRequest";
}
