/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel.constants;

import org.zhiqim.kernel.annotation.AnAlias;

/**
 * 美国信息交换标准代码(American Standard Code for Information Interchange)
 * 以下为ASCII字符集表(与ANSI字符集中的前面128个(0-127)字符相同。)
 * 
 * @version v1.0.0 @author zouzhigang 2014-3-21 新建与整理
 */
@AnAlias("AsciiConstants")
public interface AsciiConstants
{
    /******************************************************************/
    //0-31为控制符，也是空白符，trim()时会和空格一起被清除
    /******************************************************************/
    
    /** 0 NUL(null) 空字符 */
    public char _NUL_                                       = 0;
    
    /** 1 SOH(start of headline) 标题开始 */
    public char _SOH_                                       = 1;
    
    /** 2 STX (start of text) 正文开始 */
    public char _STX_                                       = 2;
    
    /** 3 ETX(end of text) 正文结束 */
    public char _EXT_                                       = 3;
    
    /** 4 EOT (end of transmission) 传输结束 */
    public char _EOT_                                       = 4;
    
    /** 5 ENQ (enquiry) 请求 */
    public char _ENQ_                                       = 5;
    
    /** 6 ACK (acknowledge) 收到通知 */
    public char _ACK_                                       = 6;
    
    /** 7 BEL (bell) 响铃 */
    public char _BEL_                                       = 7;
    
    /** 8 BS (backspace) 退格 */
    public char _BS_                                        = '\b';
    
    /** 9 HT (horizontal tab) 水平制表符 */
    public char _HT_                                        = '\t';
    
    /** 10 LF (NL line feed, new line) 换行键 */
    public char _LF_                                        = '\n';
    
    /** 11 VT (vertical tab) 垂直制表符 */
    public char _VT_                                        = 11;
    
    /** 12 FF (NP form feed, new page) 换页键 */
    public char _FF_                                        = '\f';
    
    /** 13 CR (carriage return) 回车键 */
    public char _CR_                                        = '\r';
    
    /** 14 SO (shift out) 不用切换 */
    public char _SO_                                        = 14;
    
    /** 15 SI (shift in) 启用切换 */
    public char _SI_                                        = 15;
    
    /** 16 DLE (data link escape) 数据链路转义  */
    public char _DLE_                                       = 16;
    
    /** 17 DC1 (device control 1) 设备控制1 */
    public char _DC1_                                       = 17;
    
    /** 18 DC2 (device control 2) 设备控制2 */
    public char _DC2_                                       = 18;
    
    /** 19 DC3 (device control 3) 设备控制3 */
    public char _DC3_                                       = 19;
    
    /** 20 DC4 (device control 4) 设备控制4 */
    public char _DC4_                                       = 20;
    
    /** 21 NAK (negative acknowledge) 拒绝接收 */
    public char _NAK_                                       = 21;
    
    /** 22 SYN (synchronous idle) 同步空闲  */
    public char _SYN_                                       = 22;
    
    /** 23 ETB (end of trans. block) 传输块结束 */
    public char _ETB_                                       = 23;
    
    /** 24 CAN (cancel) 取消 */
    public char _CAN_                                       = 24;
    
    /** 25 EM (end of medium) 介质中断 */
    public char _EM_                                        = 25;
    
    /** 26 SUB (substitute) 替补 */
    public char _SUB_                                       = 26;
    
    /** 27 ESC (escape) 换码(溢出) */
    public char _ESC_                                       = 27;
    
    /** 28 FS (file separator) 文件分割符 */
    public char _FS_                                        = 28;
    
    /** 29 GS (group separator) 分组符 */
    public char _GS_                                        = 29;
    
    /** 30 RS (record separator) 记录分离符 */
    public char _RS_                                        = 30;
    
    /** 31 US (unit separator) 单元分隔符 */
    public char _US_                                        = 31;
    
    /******************************************************************/
    //32-47为常用符和计算符
    /******************************************************************/
    
    /** 32 space 空格 */
    public char _SPACE_                                     = ' ';
    
    /** 33 ! 感叹号 */
    public char _EXCLAMATION_                               = '!';
    
    /** 34 " 双引号 */
    public char _DOUBLE_QUOTE_                              = '\"';
    
    /** 35 # 井号，数字代换号、英镑等，有代表的如C#叫c sharp和pound Please input your password, press the key well confirme */
    public char _SHARP_                                     = '#';
    
    /** 36 $ 美元号 */
    public char _DOLLAR_                                    = '$';
    
    /** 37 % 百分号 */
    public char _PERCENT_                                   = '%';
    
    /** 38 & 和与号，ampersand;and;reference;ref和；引用英['æmpəsænd]   美['æmpərsænd]  */
    public char _AMPERSAND_                                 = '&';
    
    /** 39 ' 单引号 */
    public char _QUOTE_                                     = '\'';
    
    /** 40 ( 左括号 */
    public char _OPEN_PARENTHESIS_                          = '(';
    
    /** 41 ) 右括号 */
    public char _CLOSE_PARENTHESIS_                         = '(';
    
    /** 42 * 星号、乘号，又用于指针等asterisk;multiply;star;pointer */
    public char _ASTERISK_                                  = '*';
    
    /** 43 + 加号 */
    public char _PLUS_                                      = '+';
    
    /** 44 , 逗号 */
    public char _COMMA_                                     = ',';
    
    /** 45 - 减号、负号 */
    public char _MINUS_                                     = '-';
    
    /** 46 . 点号、句号，period; dot */
    public char _DOT_                                       = '.';
    
    /** 47 / 顺斜杠，slash; divide; oblique 斜线；斜杠；除号 */
    public char _SLASH_                                     = '/';
    
    /******************************************************************/
    //48-57为数字
    /******************************************************************/
    
    public char _0_                                         = '0';//48 0
    public char _1_                                         = '1';//49 1
    public char _2_                                         = '2';//50 2
    public char _3_                                         = '3';//51 3
    public char _4_                                         = '4';//52 4
    public char _5_                                         = '5';//53 5
    public char _6_                                         = '6';//54 6
    public char _7_                                         = '7';//55 7
    public char _8_                                         = '8';//56 8
    public char _9_                                         = '9';//57 9
    
    /******************************************************************/
    //58-64为常用比较计算符
    /******************************************************************/
    
    /** 58 : 冒号 */
    public char _COLON_                                     = ':';
    
    /** 59 ; 分号 */
    public char _SEMICOLON_                                 = ';';
    
    /** 60 < 小于号 */
    public char _LESS_                                      = '<';
    
    /** 61 = 相等赋值号 */
    public char _EQUAL_                                     = '=';
    
    /** 62 > 大于号 */
    public char _GATHER_                                    = '>';
    
    /** 63 ? 问号 */
    public char _QUESTION_                                  = '?'; 
    
    /** 64 @ 邮箱地址号 */
    public char _AT_                                        = '@';
    
    /******************************************************************/
    //65-90为大写字母
    /******************************************************************/
    
    public char _A_                                         = 'A';//65 A
    public char _B_                                         = 'B';//66 B
    public char _C_                                         = 'C';//67 C
    public char _D_                                         = 'D';//68 D
    public char _E_                                         = 'E';//69 E
    public char _F_                                         = 'F';//70 F
    public char _G_                                         = 'G';//71 G
    public char _H_                                         = 'H';//72 H
    public char _I_                                         = 'I';//73 I
    public char _J_                                         = 'J';//74 J
    public char _K_                                         = 'K';//75 K
    public char _L_                                         = 'L';//76 L
    public char _M_                                         = 'M';//77 M
    public char _N_                                         = 'N';//78 N
    public char _O_                                         = 'O';//79 O
    public char _P_                                         = 'P';//80 P
    public char _Q_                                         = 'Q';//81 Q
    public char _R_                                         = 'R';//82 R
    public char _S_                                         = 'S';//83 S
    public char _T_                                         = 'T';//84 T
    public char _U_                                         = 'U';//85 U
    public char _V_                                         = 'V';//86 V
    public char _W_                                         = 'W';//87 W
    public char _X_                                         = 'X';//88 X
    public char _Y_                                         = 'Y';//89 Y
    public char _Z_                                         = 'Z';//90 Z
    
    /******************************************************************/
    //91-96为非常用计算符
    /******************************************************************/
    
    /** 91 [ 左方括号 */
    public char _OPEN_BRACKET_                              = '[';
    
    /** 92 \ 反斜杠,转义符backslash;sometimes escape反斜线转义符；有时表示转义符或续行符 */
    public char _BACK_SLASH_                                = '\\';
    
    /** 93 ] 右方括号 */
    public char _CLOSE_BRACKET_                             = ']';
    
    /** 94 ^ 乘方号，按位异等 */
    public char _CARET_                                     = '^'; 
    /** 95 _  下划线 */
    public char _UNDERLINE_                                 = '_';
    
    /** 96 ` 撇号、分词号、省字符 apostrophe 英 [əˈpɒstrəfi]     美[əˈpɑstrəfi] */
    public char _APOSTROPHE_                                = '`';
    
    /******************************************************************/
    //97-122为小写字母
    /******************************************************************/
    
    public char _a_                                         = 'a';//97 a
    public char _b_                                         = 'b';//98 b
    public char _c_                                         = 'c';//99 c
    public char _d_                                         = 'd'; //100 d
    public char _e_                                         = 'e';//101 e
    public char _f_                                         = 'f';//102 f
    public char _g_                                         = 'g';//103 g
    public char _h_                                         = 'h';//104 h
    public char _i_                                         = 'i';//105 i
    public char _j_                                         = 'j';//106 j
    public char _k_                                         = 'k';//107 k
    public char _l_                                         = 'l';//108 l
    public char _m_                                         = 'm';//109 m
    public char _n_                                         = 'n';//110 n
    public char _o_                                         = 'o';//111 o
    public char _p_                                         = 'p';//112 p
    public char _q_                                         = 'q';//113 q
    public char _r_                                         = 'r';//114 r
    public char _s_                                         = 's';//115 s
    public char _t_                                         = 't';//116 t
    public char _u_                                         = 'u';//117 u
    public char _v_                                         = 'v';//118 v
    public char _w_                                         = 'w';//119 w
    public char _x_                                         = 'x';//120 x
    public char _y_                                         = 'y';//121 y
    public char _z_                                         = 'z';//122 z
    
    /******************************************************************/
    //123-127为右侧非常用符
    /******************************************************************/
    
    /** 123 { 左花括号 */
    public char _OPEN_BRACE_                                = '{';
    
    /** 124 | 竖杠 */
    public char _VERTICAL_BAR_                              = '|';
    
    /** 125 } 右花括号 */
    public char _CLOSE_BRACE_                               = '{';
    
    /** 126 ~ 波浪号 */
    public char _TILDE_                                     = '~';
    
    /** 127 DEL 删除键 */
    public char _DEL_                                       = 127;


    /******************************************************************/
    //其他常用到的键
    /******************************************************************/
    
    /** 中文空格 */
    public int _SPACE_ZH_                                   = 12288;//0x3000
    
    /** BOM开头空格，UTF-8,UTF-16存在 */
    public int _SPACE_BOM_                                  = 65279;//0xFEFF;
    
    /** Ctrl键 */
    public int _CTRL_                                       = 262144;//0x00040000
    
    /** Shift键 */
    public int _SHIFT_                                      = 131072;//0x00020000
}
