/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel;

import org.zhiqim.kernel.constants.ZhiqimConstants;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;

/**
 * 知启蒙工程退出锚，当Runtime捕捉到shutdown时会调用该锚，用于退出清理
 * 
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
final class ZhiqimHook extends Thread implements ZhiqimConstants
{
    private static final Log log = LogFactory.getLog(ZhiqimHook.class);
    
    public void run()
    {
        //1.退出开始日志
        log.info("系统[%s]-版本[%s]正在退出...", Global.getName(), Global.getVersion());
        
        //2.退出所有服务
        Global.removeServiceAll();

        //3.退出完成日志
        log.info("系统[%s]-版本[%s]退出完成...", Global.getName(), Global.getVersion());
    }
}