/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_kernel.htm
 *
 * This file is part of [zhiqim_kernel].
 * 
 * [zhiqim_kernel] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * [zhiqim_kernel] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_kernel].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.kernel;

/**
 * 工程服务，实现了工程服务接口的类，在conf/zhiqim.xml中配置则会注册到Global中
 * 
 * @version v1.0.0 @author zouzhigang 2014-2-27 新建与整理
 */
public interface Service extends MultiInstance
{
    /*********************************************************/
    //服务编号
    /*********************************************************/
    
    /** 设置服务编号,对应conf/zhiqim.xml/service/key */
    public void setId(String id);
    
    /** 获取服务编号 */
    public String getId();
    
    /*********************************************************/
    //服务创建和销毁
    /*********************************************************/
    
    /**
     * 服务创建接口，配置信息从Global中读取
     * 
     * @return boolean =true,启动成功,=false,启动失败
     * @throws Exception Startup捕捉,打印日志,作失败处理
     */
    public boolean create() throws Exception;
    
    /**
     * 服务销毁接口，配置信息从Global中读取
     * 
     * @throws Exception Hook捕捉,打印日志,异常不处理，直接退出
     */
    public void destroy() throws Exception;
    
    /*********************************************************/
    //更新和测试更新配置
    /*********************************************************/
    
    /**
     * 测试更新配置
     * 
     * @return              =true表示可以更新，=false表示更新可能有问题
     * @throws Exception    异常时表示不可更新
     */
    public boolean test() throws Exception;
    
    /**
     * 服务更新配置
     * 
     * @throws Exception 出现更新异常通知配置端
     */
    public void update() throws Exception;
}
