/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.datasource;

import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.zhiqim.kernel.extend.LinkedMapSO;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.extend.TreeMapSO;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.dbo.Dbo;
import org.zhiqim.orm.dbo.DboField;

public class ZResultSet
implements ORMConstants {
    public static List<?> parseToBase(ResultSet rst, Class<?> resultClass) throws SQLException {
        if (!rst.next()) {
            return new ArrayList();
        }
        ArrayList<Object> resultList = new ArrayList<Object>();
        ResultSetMetaData rstMeta = rst.getMetaData();
        int columnCount = rstMeta.getColumnCount();
        do {
            if (columnCount == 1) {
                resultList.add(ZResultSet.getValue(resultClass, rst, 1));
                continue;
            }
            Object[] result = new Object[columnCount];
            int i = 1;
            while (i <= columnCount) {
                result[i - 1] = ZResultSet.getValue(resultClass, rst, i);
                ++i;
            }
            resultList.add(result);
        } while (rst.next());
        resultList.trimToSize();
        return resultList;
    }

    public static List<?> parseToMap(ResultSet rst, Class<?> resultClass) throws SQLException {
        if (!rst.next()) {
            return new ArrayList();
        }
        ArrayList resultList = new ArrayList();
        ResultSetMetaData rstMeta = rst.getMetaData();
        int columnCount = rstMeta.getColumnCount();
        do {
            LinkedMapSO result = new LinkedMapSO(columnCount);
            int i = 1;
            while (i <= columnCount) {
                int type = rstMeta.getColumnType(i);
                String columnName = rstMeta.getColumnName(i);
                switch (type) {
                    case 2005: {
                        Clob clob = rst.getClob(i);
                        if (clob != null) {
                            result.put(columnName, (Object)clob.getSubString(1L, (int)clob.length()));
                            break;
                        }
                        result.put(columnName, null);
                        break;
                    }
                    default: {
                        Object obj = rst.getObject(i);
                        result.put(columnName, obj);
                    }
                }
                ++i;
            }
            if (resultClass == Map.class || resultClass == HashMap.class || resultClass == LinkedHashMap.class) {
                resultList.add(result.instance());
                continue;
            }
            if (resultClass == TreeMap.class) {
                resultList.add(new TreeMap(result.instance()));
                continue;
            }
            if (resultClass == TreeMapSO.class) {
                resultList.add(new TreeMapSO((MapSO)result));
                continue;
            }
            resultList.add(result);
        } while (rst.next());
        resultList.trimToSize();
        return resultList;
    }

    public static List<?> parseToDbo(ResultSet rst, Dbo resultDbo) throws Exception {
        if (!rst.next()) {
            return new ArrayList();
        }
        ArrayList<Object> resultList = new ArrayList<Object>();
        ResultSetMetaData rstMeta = rst.getMetaData();
        int columnCount = rstMeta.getColumnCount();
        do {
            Object result = Classes.newInstance((String)resultDbo.getName());
            int i = 1;
            while (i <= columnCount) {
                String columnName = rstMeta.getColumnName(i);
                int columnType = rstMeta.getColumnType(i);
                ZResultSet.parseToDboField(rst, result, resultDbo, columnName, columnType, i);
                ++i;
            }
            resultList.add(result);
        } while (rst.next());
        resultList.trimToSize();
        return resultList;
    }

    private static void parseToDboField(ResultSet rst, Object result, Dbo dbo, String columnName, int columnType, int i) throws Exception {
        DboField field = dbo.getField(columnName);
        if (field == null) {
            return;
        }
        Class<?> clazz = result.getClass();
        String method = field.getSetMethod();
        int type = field.getType();
        Object obj = null;
        Method m = null;
        switch (type) {
            case 4: {
                obj = rst.getBoolean(i);
                m = clazz.getMethod(method, Boolean.TYPE);
                break;
            }
            case 5: {
                obj = rst.getInt(i);
                m = clazz.getMethod(method, Integer.TYPE);
                break;
            }
            case 6: {
                obj = rst.getInt(i);
                m = clazz.getMethod(method, Integer.TYPE);
                break;
            }
            case 2: {
                obj = rst.getInt(i);
                m = clazz.getMethod(method, Integer.TYPE);
                break;
            }
            case 3: {
                obj = rst.getLong(i);
                m = clazz.getMethod(method, Long.TYPE);
                break;
            }
            case 8: {
                obj = rst.getDouble(i);
                m = clazz.getMethod(method, Double.TYPE);
                break;
            }
            case 7: {
                obj = rst.getTimestamp(i);
                break;
            }
            case 1: {
                if (2005 == columnType) {
                    Clob clob = rst.getClob(i);
                    if (clob == null) break;
                    obj = clob.getSubString(0L, (int)clob.length());
                    break;
                }
                obj = rst.getString(i);
                break;
            }
            case 9: {
                if (2004 == columnType) {
                    Blob blob = rst.getBlob(i);
                    if (blob == null) break;
                    obj = blob.getBytes(1L, (int)blob.length());
                    break;
                }
                obj = rst.getBytes(i);
                break;
            }
            default: {
                obj = rst.getObject(i);
            }
        }
        if (obj != null) {
            if (m == null) {
                m = clazz.getMethod(method, obj.getClass());
            }
            m.invoke(result, obj);
        }
    }

    public static Object getValue(Class<?> resultClass, ResultSet rst, int index) throws SQLException {
        if (resultClass == Boolean.TYPE || resultClass == Boolean.class) {
            return rst.getBoolean(index);
        }
        if (resultClass == Byte.TYPE || resultClass == Byte.class || resultClass == Short.TYPE || resultClass == Short.class || resultClass == Integer.TYPE || resultClass == Integer.class) {
            return rst.getInt(index);
        }
        if (resultClass == Long.TYPE || resultClass == Long.class) {
            return rst.getLong(index);
        }
        if (resultClass == Timestamp.class) {
            return rst.getTimestamp(index);
        }
        if (resultClass == Date.class) {
            return rst.getDate(index);
        }
        if (resultClass == Time.class) {
            return rst.getTime(index);
        }
        if (resultClass == String.class) {
            return rst.getString(index);
        }
        if (resultClass == byte[].class) {
            return rst.getBytes(index);
        }
        return rst.getObject(index);
    }
}

