/**
 * 扬彩印刷设计 
 * 文件名  :TaoYinTongClientUtil.java
 * 创建人  :gjx
 * 创建时间:2019-9-23
 */

package org.zhiqim.manager.util;

import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.httpclient.HttpGet;
import org.zhiqim.kernel.httpclient.HttpPost;
import org.zhiqim.kernel.httpclient.HttpResult;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Validates;

/**
 * 淘印通接口调用工具类
 * 
 * @version 1.0 @author gjx 2019-9-23 新建与整理
 */
public class TaoYinTongClientUtil
{
    /** 淘印通token请求地址 生产 */
    //public static final String TAOYIN_TOKEN_URL = "https://ty.yunprints.com/gateway/admin-auth/oauth/token?username=managerClientUser&password=123456&grant_type=password&scope=scope_ManagerClient_trust&client_id=ManagerClient&client_secret=secret_ManagerClient20190101";
    /** 淘印通token请求地址 测试 */
    public static final String TAOYIN_TOKEN_URL = "http://192.168.3.115:9201/admin-auth/oauth/token?username=managerClientUser&password=123456&grant_type=password&scope=scope_ManagerClient_trust&client_id=ManagerClient&client_secret=secret_ManagerClient20190101";


    private static final Log log = LogFactory.getLog(TaoYinTongClientUtil.class);

    /**
     * 
     * [简要描述]:获取淘印通接口访问令牌 <br/>
     * [详细描述]:<br/>
     * 
     * @author gjx
     * @param url 接口url
     * @return token
     * @throws IllegalArgumentException
     */
    public static String getAccessToken() throws IllegalArgumentException
    {
        if (Validates.isEmpty(TAOYIN_TOKEN_URL))
        {// 非法参数
            throw new IllegalArgumentException("非法请求参数");
        }
        HttpPost post = new HttpPost(TAOYIN_TOKEN_URL);
        post.setConnectTimeout(3);
        post.setReadTimeout(3);
        post.execute();

        HttpResult result = post.getResult();
        int responseStatus = result.getResponseStatus();
        String resultText = result.getResponseText();
        String access_token = "";

        if (!result.isSuccess())
        {
            log.error("获取淘印通访问令牌Http错误，[ " + responseStatus + " ][ " + resultText + " ]");
        }

        MapSO map = Jsons.toMapSO(resultText);
        if (Validates.isNotEmpty(map))
        {
            access_token = String.valueOf(map.get("access_token"));
        }
        return access_token;

    }

    /**
     * 
     * [简要描述]:淘印通参数数据调用 <br/>
     * [详细描述]:<br/>
     * 
     * @author gjx
     * @param url 接口地址
     * @param dicKeyCode 获取参数标识key
     * @param access_token token
     * @return json
     */
    public static String getTaoYinParamInfo(String url, String dicKeyCode, String access_token)
    {
        if (Validates.isEmpty(url) || Validates.isEmpty(dicKeyCode) || Validates.isEmpty(Validates.isEmpty(url)))
        {
            throw new IllegalArgumentException("非法请求参数");
        }
        StringBuilder builder = new StringBuilder(url);
        builder.append("?dicKeyCode=" + dicKeyCode);
        builder.append("&access_token=" + access_token);

        HttpGet get = new HttpGet(builder.toString());
        get.setConnectTimeout(3);
        get.setReadTimeout(3);
        get.execute();

        HttpResult result = get.getResult();
        int responseStatus = result.getResponseStatus();
        String resultText = result.getResponseText();

        if (!result.isSuccess())
        {
            log.error("获取淘印通统一配置，Http错误，[ " + responseStatus + " ][ " + resultText + " ]");
        }

        return resultText;
    }
}
