/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.presenter;

import java.util.List;

import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpCookie;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.context.ZmlBootstrap;
import org.zhiqim.httpd.context.ZmlContexts;
import org.zhiqim.httpd.context.core.Context;
import org.zhiqim.httpd.util.Sessions;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.httpd.validate.ones.IsNumericLen;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.util.codes.Base64;
import org.zhiqim.kernel.util.codes.RSA;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrBootstrapApi;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.ZmrPassworder;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrOperatorDao;
import org.zhiqim.manager.dao.ZmrParamDao;
import org.zhiqim.manager.dbo.ZmrMenu;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.manager.dbo.ZmrOrg;

/**
 * 登陆控制器
 *
 * @version v1.0.0 @author liuhu 2018-8-2 新建与整理
 */
@AnAlias("ZmrLoginPresenter")
public class ZmrLoginPresenter implements ZmrConstants
{
    public static void doLogin(HttpRequest request) throws Exception
    {
        HttpContext context = request.getContext();
        
        //1.判断传入参数
        request.addValidate(new IsNotEmpty("operatorCode", "用户名不能为空"));
        request.addValidate(new IsNotEmpty("operatorPass", "密码不能为空"));
        
        if(ZmrParamDao.hasVerificationCode(context)){
            request.addValidate(new IsNumericLen("verificationCode", "验证码必须是4位数字", 4, 4));
        }
        if (!request.chkValidate())
        {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        
        //2.验证码
        if(ZmrParamDao.hasVerificationCode(context))
        {
            String verificationCode = request.getParameter("verificationCode");
            if(verificationCode.length() != 4)
            {
                request.setResponseError("验证码必须是4位数字");
                return;
            }
            String vcode = Sessions.getSessionVerificationCode(request);
            if (!verificationCode.equals(vcode))
            {
                request.setResponseError("验证码不正确或已失效，请新输入！");
                return;
            }
        }
        
        //3.验证操作员编码是否存在、是否停用，是否组停用
        String operatorCode = request.getParameter("operatorCode");
        ZmrOperator operator = ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, operatorCode);
        if(operator == null)
        {
            request.setResponseError("用户名不正确");
            return;
        }
        
        if(operator.getOperatorStatus() == 1)
        {
            request.setResponseError("该用户已停用，不允许登录");
            return;
        }
        
        ZmrOrg org = ZmrBootstrap.tableOpr(request).item(ZmrOrg.class, operator.getOrgId());
        if(org == null || org.getOrgStatus() == 1)
        {
            request.setResponseError("该用户所属组织不存在或已停用");
            return;
        }
        
        //4.验证密码
        String operatorPass = request.getParameter("operatorPass");
        
        byte[] operatorPassByte = Base64.decode(operatorPass);
        String privateKey = ZmrParamDao.getPrivateKey(context);
        byte[] operatorPassDecrypt = RSA.decrypt(operatorPassByte, privateKey);
        operatorPass = new String(operatorPassDecrypt, _UTF_8_C_);
        
        if (isValidateRememberPass(operatorPass))
        {//全是●的密码表示记住密码要求验证密钥
            if (!ZmrParamDao.hasRememberCode(context) || !ZmrParamDao.hasRememberPass(context) || !operatorCode.equals(request.getCookie("operatorCode")))
            {
                request.setResponseError("用户密码不正确");
                return;
            }
            
            ZmrPassworder passworder = request.getContextAttribute(ZmrBootstrap.class).getPassworder();
            String operatorPassSecr = request.getCookie("operatorPass");
            if (!passworder.secretChk(operatorCode, operatorPass, operator.getOperatorPassSalt(), operatorPassSecr))
            {
                request.setResponseError("用户密码不正确");
                return;
            }
        }
        else
        {//正常验证密码
            if(!ZmrOperatorDao.validatePassword(request, operator, operatorPass))
            {
                request.setResponseError("用户密码不正确");
                return;
            }
        }
        
        List<ZmrMenu> menuList = ZmrOperatorDao.getOperatorMenuList(request, operator);
        if(menuList.isEmpty())
        {
            request.setResponseError("您暂没有任何操作权限，请与管理员联系");
            return;
        }
        
        //5.完成验证，组装会话用户
        ZmrSessionUser sessionUser = new ZmrSessionUser()
            .setOperator(operator)
            .setMenuList(context, menuList);
            sessionUser.setSelectedOrgId(operator.getOrgId());
        
        request.bindSessionUser(sessionUser);
        
        //6.判断需要保存信息到COOKIE
        if(ZmrParamDao.hasRememberCode(context))
        {
            boolean rememberCode = request.getParameterBoolean("rememberCode");
            boolean rememberPass = request.getParameterBoolean("rememberPass");
            int day30 = 60*60*24*30;
            
            HttpResponse response = request.getResponse();
            if(rememberPass)
            {//勾选了记住密码，则一定记住登录名
                ZmrPassworder passworder = request.getContextAttribute(ZmrBootstrap.class).getPassworder();
                String operatorSecr = passworder.secret(operatorCode, operatorPass, operator.getOperatorPassSalt());
                response.addCookie(new HttpCookie("operatorCode", operatorCode, day30));
                response.addCookie(new HttpCookie("operatorPass", operatorSecr, day30));
            }
            else if (rememberCode)
            {//只记住用户名
                response.addCookie(new HttpCookie("operatorCode", operatorCode, day30));
                response.addCookie(new HttpCookie("operatorPass", "", day30));
            }
            else
            {//否则设置值为空
                response.addCookie(new HttpCookie("operatorCode", "", day30));
                response.addCookie(new HttpCookie("operatorPass", "", day30));
            }
        }
        
        //7.判断是否填写了主页跳转地址
        String mainUrl = request.getRootPath(ZmlContexts.parseZmlContent(request, ZmrParamDao.getMainUrl(context)));
        if (!ZmrParamDao.isThemeFrame(context))
        {
            request.setResponseResult(mainUrl);
        }
        else
        {
            String defaultUrl = request.getRootPath(ZmlContexts.parseZmlContent(request, ZMR_MAIN_URL_DEFAULT));
            String welcomeUrl = request.getRootPath(ZmlContexts.parseZmlContent(request, ZMR_MAIN_URL_WELCOME));
            sessionUser.setWelcomeUrl(welcomeUrl);
            sessionUser.setMainUrl(defaultUrl.equals(mainUrl)?welcomeUrl:mainUrl);
            request.setResponseResult(defaultUrl);
        }
        
        //8.最后回调登录
        ZmlBootstrap bootstrap = ((Context)context).getBootstrap();
        if (bootstrap instanceof ZmrBootstrapApi)
        {
            ((ZmrBootstrapApi)bootstrap).logined(request);
        }
    }
    
    private static boolean isValidateRememberPass(String operatorPass)
    {
        for (int i=0;i<operatorPass.length();i++)
        {
            if (operatorPass.charAt(i) != '●')
                return false;
        }
        return true;
    }
}
