/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.presenter;

import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.ZmlContexts;
import org.zhiqim.httpd.context.annotation.AnIntercept;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.tree.Tree;
import org.zhiqim.kernel.tree.TreeBuilder;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrOrgDao;
import org.zhiqim.manager.dbo.ZmrDept;
import org.zhiqim.manager.dbo.ZmrDeptRule;
import org.zhiqim.manager.dbo.ZmrMenu;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

/**
 * 操作员部门控制器
 *
 * @version v1.0.0 @author zouzhigang 2017-6-6 新建与整理
 */
@AnAlias("ZmrDeptPresenter")
@AnIntercept("chkZmrLogin")
public class ZmrDeptPresenter implements ZmrConstants
{
    /** 显示部门成员列表 */
    public static void doShowDeptOperatorList(HttpRequest request) throws Exception
    {
        long deptId = request.getParameterLong("deptId");
        if (deptId == -1)
        {
            request.setResponseError("您选择的部门不存在，请选择一个有效的部门");
            return;
        }
        
        ZmrDept dept = ZmrBootstrap.table(request).item(ZmrDept.class, deptId);
        if (dept == null)
        {
            request.setResponseError("您选择的部门不存在，请选择一个有效的部门");
            return;
        }
        
        Selector selector = new Selector();
        selector.addMustLike("operatorDept", deptId);
        List<ZmrOperator> operatorList = ZmrBootstrap.tableOpr(request).list(ZmrOperator.class, selector);
        
        MapSO variable = new HashMapSO();
        variable.put("dept", dept);
        variable.put("operatorList", operatorList);
        
        String responseText = ZmlContexts.parseZmlPath(request, "/zview/zhiqim_manager/presenter/deptOperatorInfo.zml", variable);
        request.setResponseResult(responseText);
        
        //设置为当前选中
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        sessionUser.setValue(ZMR_SESSION_USER_DEPT_ID, deptId);
    }
    
    /** 显示部门权限列表 */
    public static void doShowDeptRuleList(HttpRequest request) throws Exception
    {
        long deptId = request.getParameterLong("deptId");
        if (deptId == -1)
        {
            request.setResponseError("您选择的部门不存在，请选择一个有效的部门");
            return;
        }
        
        ZmrDept dept = ZmrBootstrap.table(request).item(ZmrDept.class, deptId);
        if (dept == null)
        {
            request.setResponseError("您选择的部门不存在，请选择一个有效的部门");
            return;
        }
        
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        
        // 获取部门权限
        List<ZmrDeptRule> ruleList = ZmrBootstrap.table(request).list(ZmrDeptRule.class, new Selector("deptId", deptId));
        
        //获取能管理的权限（组织权限）
        List<ZmrMenu> list = ZmrOrgDao.getMenuList(request, dept.getOrgId());
        Tree<ZmrMenu> tree = TreeBuilder.newTree(list, "parentCode", "menuCode");
        
        MapSO variable = new HashMapSO();
        variable.put("dept", dept);
        variable.put("tree", tree);
        variable.put("menuSize", list.size());
        variable.put("ruleList", ruleList);
        
        String responseText = ZmlContexts.parseZmlPath(request, "/zview/zhiqim_manager/presenter/deptRuleInfo.zml", variable);
        request.setResponseResult(responseText);
        
        //设置为当前选中
        sessionUser.setValue(ZMR_SESSION_USER_DEPT_ID, deptId);
    }
    
    /** 增加多个部门成员 */
    public static void doAddDeptOperator(HttpRequest request) throws Exception
    {
        request.addValidate(new IsNotEmpty("deptId", "请选择一个部门"));
        request.addValidate(new IsNotEmpty("operatorCodes", "请选择操作员"));
        if (!request.chkValidate())
        {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        
        //判断部门是否存在
        long deptId = request.getParameterLong("deptId");
        ZmrDept dept = ZmrBootstrap.table(request).item(ZmrDept.class, deptId);
        if (dept == null)
        {
            request.returnHistory("您选择的部门不存在，请选择一个有效的部门");
            return;
        }
        
        String[] operatorCodeArr = Arrays.toStringArray(request.getParameter("operatorCodes"));
        for (String operatorCode : operatorCodeArr)
        {
            ZmrOperator operator = ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, operatorCode);
            if (operator == null)
                continue;
        
            //操作员部门
            String operatorDept = operator.getOperatorDept();
            if (Validates.isEmpty(operatorDept))
                operatorDept = "" + deptId;
            else
                operatorDept += "," + deptId;
            
            //操作员所有部门
            String operatorDeptAll = operator.getOperatorDeptAll();
            if (Validates.isEmpty(operatorDeptAll))
                operatorDeptAll = dept.getDeptParentAll();
            else
                operatorDeptAll += "," + dept.getDeptParentAll();
            operatorDeptAll += "," + operatorDept;
            
            //去重
            operatorDeptAll = Arrays.toFilterSameStr(Arrays.toStringArray(operatorDeptAll));
            
            Updater updater = new Updater();
            updater.addField("operatorDept", operatorDept);
            updater.addField("operatorDeptAll", operatorDeptAll);
            updater.addMust("operatorCode", operatorCode);
            
            ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
            
            //设置为当前选中
            ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
            sessionUser.setValue(ZMR_SESSION_USER_DEPT_ID, deptId);
        }
    }
}
