/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[遇见知启蒙，邂逅框架梦]
 * 知启蒙WEB容器（zhiqim_httpd）在LGPL3.0协议下开源：https://www.zhiqim.com/gitcan/zhiqim/zhiqim_httpd.htm
 * This file is part of [zhiqim_httpd].
 * [zhiqim_httpd] is free software: you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * [zhiqim_httpd] is distributed in the hope that it will
 * be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with [zhiqim_httpd].
 * If not, see <http://www.gnu.org/licenses/>.
 */
package org.zhiqim.manager.messagebox;

import org.apache.rocketmq.client.exception.MQClientException;
import org.zhiqim.httpd.HttpSession;
import org.zhiqim.httpd.HttpSessionUser;
import org.zhiqim.httpd.HttpWebsocket;
import org.zhiqim.httpd.HttpWebsocketConnection;
import org.zhiqim.httpd.HttpWebsocketMessage;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;

@AnAlias("message_box")
public class ZqmMessageBoxWS implements HttpWebsocket
{
    private static final Log log = LogFactory.getLog(ZqmMessageBoxWS.class);

    @Override
    public void onOpen(HttpWebsocketConnection conn)
    {
        if (!"message_box".equals(conn.getProtocol()))
            return;
        HttpSessionUser sessionUser = conn.getSession().getSessionUser();
        if (sessionUser == null)
        {
            conn.close();
            return;
        }
        try
        {
            ZqmMessageUtil.putUserChannel(sessionUser.getSessionName(), conn);
            log.info("open:" + sessionUser.getSessionName());
        }
        catch (MQClientException e1)
        {
            conn.close();
            log.error("打开消费者失败", e1);
        }
    }

    @Override
    public void onClose(HttpWebsocketConnection conn)
    {
        if (!"message_box".equals(conn.getProtocol()))
            return;
        HttpSessionUser sessionUser = conn.getSession().getSessionUser();
        if (sessionUser == null)
            return;
        ZqmMessageUtil.removeConnection(conn);
        log.info("close:" + conn.getSession().getSessionUser().getSessionName());
    }

    @Override
    public void onException(HttpWebsocketConnection conn, Throwable e)
    {
        if (!"message_box".equals(conn.getProtocol()))
            return;
        HttpSessionUser sessionUser = conn.getSession().getSessionUser();
        if (sessionUser == null)
            return;
        ZqmMessageUtil.removeConnection(conn);
        log.info("exception:" + sessionUser.getSessionName());
    }

    @Override
    public void onMessage(HttpWebsocketConnection conn, String message)
    {
        if (!"message_box".equals(conn.getProtocol()))
            return;
        HttpSession session = conn.getSession();
        HttpSessionUser sessionUser = session.getSessionUser();
        if (sessionUser == null)
        {
            conn.close();
            return;
        }

        log.info("message:" + sessionUser.getSessionName());
        conn.send(new HttpWebsocketMessage().buildPong().toBytes());
    }

    @Override
    public void onMessage(HttpWebsocketConnection conn, byte[] message)
    {
        if (!"message_box".equals(conn.getProtocol()))
            return;
        HttpSessionUser sessionUser = conn.getSession().getSessionUser();
        if (sessionUser == null)
        {
            conn.close();
            return;
        }

        log.info("message:" + sessionUser.getSessionName());
        conn.send(new HttpWebsocketMessage().buildPong().toBytes());
    }

}
