package org.zhiqim.manager.messagebox;

import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.MQProducer;
import org.zhiqim.kernel.Global;
import java.util.concurrent.ConcurrentHashMap;

public class ZqmMessageBoxMQProducerFactory {

    private static ConcurrentHashMap<String, DefaultMQProducer> MQProducerMap = new ConcurrentHashMap<>(50);

    /**
     * 获取的MQ生产者
     *
     * @param producerGroupName
     * @return
     * @throws MQClientException
     */
    public static MQProducer getMQProducer(String producerGroupName) throws MQClientException {
        DefaultMQProducer producer = MQProducerMap.get(producerGroupName);
        if (producer == null) {
            synchronized (MQProducerMap) {
                if (producer == null) {
                    producer = new DefaultMQProducer(producerGroupName);
                    producer.setNamesrvAddr(Global.getString("message-box", "mqAddress"));
                    producer.start();
                    MQProducerMap.put(producerGroupName, producer);
                }
            }
        }
        return producer;
    }
}
