/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.dbo;

import java.io.Serializable;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNew;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.orm.annotation.*;

/**
 * 系统操作员参数表 对应表《ZMR_PARAM_OPERATOR》
 */
@AnAlias("ZmrParamOperator")
@AnNew
@AnTable(table="ZMR_PARAM_OPERATOR", key="PARAM_KEY", type="InnoDB")
public class ZmrParamOperator implements Serializable
{
    private static final long serialVersionUID = 1L;

    @AnTableField(column="PARAM_KEY", type="string,32", notNull=true)    private String paramKey;    //1.参数键
    @AnTableField(column="PARAM_DESC", type="string,200", notNull=true)    private String paramDesc;    //2.参数描述

    public String toString()
    {
        return Jsons.toString(this);
    }

    public String getParamKey()
    {
        return paramKey;
    }

    public void setParamKey(String paramKey)
    {
        this.paramKey = paramKey;
    }

    public String getParamDesc()
    {
        return paramDesc;
    }

    public void setParamDesc(String paramDesc)
    {
        this.paramDesc = paramDesc;
    }

}
