/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager.action;

import java.util.List;

import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.manager.dbo.ZmrParamOperator;

/**
 * 操作员信息
 * @version v1.0.0 @author zhouwenbin 2017-5-31 新建与整理
 */
public class ProfileAction implements Action
{

    @Override
    public void execute(HttpRequest request) throws Exception
    {
        ZmrSessionUser sessionUser = request.getSessionUser(ZmrSessionUser.class);
        
        ZmrOperator operator = ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, sessionUser.getOperatorCode());
        List<ZmrParamOperator> operatorParamList = ZmrBootstrap.tableOpr(request).list(ZmrParamOperator.class);
        
        request.setAttribute("operator", operator);
        request.setAttribute("operatorParamList", operatorParamList);
    }
}
