/*
 * 版权所有 (C) 2015 知启蒙(ZHIQIM) 保留所有权利。[欢迎加盟知启蒙，一起邂逅框架梦]
 * 
 * https://www.zhiqim.com/gitcan/zhiqim/zhiqim_manager.htm
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.zhiqim.manager;

import java.sql.SQLException;

import org.zhiqim.httpd.HttpContext;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.dao.ZmrParamDao;
import org.zhiqim.orm.ORMException;
import org.zhiqim.zml.ZmlVarRuntime;

/**
 * 变量zhiqim.js运行时取值，对应格式如：
 * <#var zhiqim.js = new ZmrCdnRuntime(context, "/service/res/zhiqim_v1.4.0.r2018010101.min.js")/>
 *
 * @version v1.0.0 @author zouzhigang 2018-2-26 新建与整理
 */
@AnAlias("ZmrCdnRuntime")
public class ZmrCdnRuntime implements ZmlVarRuntime, ZmrConstants
{
    private HttpContext context;
    private String pathInContext;
    
    public ZmrCdnRuntime(HttpContext context, String pathInContext)
    {
        this.context = context;
        this.pathInContext = pathInContext;
    }
    
    @Override
    public Object build()
    {
        try
        {
            String cdnPath = ZmrParamDao.getString(context, ZMR_NAME, ZMR_CDN_PATH);
            if (Validates.isEmptyBlank(cdnPath))
                return context.getRootPath(pathInContext);
            else
                return Strings.trimRight(cdnPath, "/") + pathInContext;
        }
        catch (ORMException | SQLException e)
        {
            return context.getRootPath(pathInContext);
        }
    }
}
