/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnNullable;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Sqls"})
public class Sqls {
    public static String formatQuote(String sql) {
        return sql.replaceAll("'", "''");
    }

    public static String formatSpace(String sql) {
        sql = sql.replaceAll("\n", " ");
        sql = sql.replaceAll("\r", " ");
        sql = sql.replaceAll("\t", " ");
        return Strings.formatSpace(sql);
    }

    public static String formatReplaceMap(String sql, MapSS replaceMap) {
        if (replaceMap == null || replaceMap.isEmpty()) {
            return sql;
        }
        return Sqls.formatReplaceMap(sql, replaceMap.instance());
    }

    public static String formatReplaceMap(String sql, Map<String, String> replaceMap) {
        if (replaceMap == null || replaceMap.isEmpty()) {
            return sql;
        }
        for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sql = sql.replaceAll("\\$" + key + "\\$", value);
        }
        return sql;
    }

    @AnNullable
    public static String toDateTimeString(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(timestamp);
    }

    @AnNullable
    public static String toDateString(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(timestamp);
    }

    @AnNullable
    public static String toDateString(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    @AnNullable
    public static String toTimeString(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new SimpleDateFormat("HH:mm:ss").format(timestamp);
    }

    @AnNullable
    public static String toTimeString(Time time) {
        if (time == null) {
            return null;
        }
        return new SimpleDateFormat("HH:mm:ss").format(time);
    }

    public static Date toDate(String date) {
        return Date.valueOf(date);
    }

    public static Date toDate(String year, String month, String day) {
        return Date.valueOf(String.valueOf(year) + "-" + month + "-" + day);
    }

    public static Date toDate(int year, int month, int day) {
        return Date.valueOf(String.valueOf(year) + "-" + month + "-" + day);
    }

    public static Time toTime(String time) {
        return Time.valueOf(time);
    }

    public static Time toTime(String hour, String minute, String second) {
        return Time.valueOf(String.valueOf(hour) + ":" + minute + ":" + second);
    }

    public static Time toTime(int hour, int minute, int second) {
        return Time.valueOf(String.valueOf(hour) + ":" + minute + ":" + second);
    }

    public static Timestamp nowTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Timestamp toTimestamp(String datetime) {
        return Timestamp.valueOf(datetime);
    }

    public static Timestamp toTimestamp(String date, String time) {
        return Timestamp.valueOf(String.valueOf(date) + " " + time);
    }

    public static Timestamp toTimestamp(String year, String month, String day, String hour, String minute, String second) {
        return Timestamp.valueOf(year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second);
    }

    public static Timestamp toTimestamp(int year, int month, int day, int hour, int minute, int second) {
        return Timestamp.valueOf(new StringBuilder(year).append("-").append(month).append("-").append(day).append(" ").append(hour).append(":").append(minute).append(":").append(second).toString());
    }

    public static Timestamp toTimestampBegin(String date) {
        return Sqls.toTimestamp(date, "00:00:00");
    }

    public static Timestamp toTimestampEnd(String date) {
        return Sqls.toTimestamp(date, "23:59:59");
    }

    public static Timestamp toTimestampBegin(Timestamp stamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(stamp);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp toTimestampEnd(Timestamp stamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(stamp);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp getNextTimestampBegin(Timestamp stamp) {
        return Sqls.getNextTimestampBegin(stamp, 1);
    }

    public static Timestamp getNextTimestampBegin(Timestamp stamp, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(stamp);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, day);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp getNextTimestampEnd(Timestamp stamp) {
        return Sqls.getNextTimestampEnd(stamp, 1);
    }

    public static Timestamp getNextTimestampEnd(Timestamp stamp, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(stamp);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        calendar.add(5, day);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static List<String> toSqlList(String sqls) {
        String[] sqlArr;
        if (Validates.isEmptyBlank(sqls)) {
            return new ArrayList<String>();
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        String[] stringArray = sqlArr = Arrays.toStringArray(sqls, "\n");
        int n = sqlArr.length;
        int n2 = 0;
        while (n2 < n) {
            String sql = stringArray[n2];
            if (!(Validates.isEmpty(sql = Strings.trim(sql)) || Strings.startsWith(sql, "--") || Strings.startsWith(sql, "commit"))) {
                sql = Strings.trimRight(sql, ";");
                sqlList.add(sql);
            }
            ++n2;
        }
        return sqlList;
    }
}

