/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.schedule;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.schedule.TaskThreader;
import org.zhiqim.kernel.util.DateTimes;

@AnAlias(value={"Minute5"})
public final class Minute5
extends TaskThreader {
    private int taskMinute = 0;
    private int taskSecond = 0;

    public Minute5() {
    }

    public Minute5(Task task, int minute, int second) {
        this.schedule(task, new int[]{minute, second});
    }

    @Override
    public String getName() {
        return "Minute5";
    }

    @Override
    public String getTime() {
        return this.taskMinute + "/" + this.taskSecond;
    }

    @Override
    protected TaskThreader schedule(Task task, int[] time) {
        if (task == null || time == null || time.length != 2) {
            throw new RuntimeException("Minute5\u4f20\u5165\u7684\u53c2\u6570\u4e3a\u7a7a\u6216\u6570\u7ec4\u957f\u5ea6\u4e0d\u5bf9");
        }
        if (time[0] < 0 || time[0] > 4 || time[1] < 0 || time[1] > 59) {
            throw new RuntimeException("Minute5\u4f20\u65f6\u7684\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        this.task = task;
        this.taskMinute = time[0];
        this.taskSecond = time[1];
        return this;
    }

    @Override
    protected long calcLastTime(int curYearMonth, int curMonthMaxDay, int curDay, int curHour, int curMinute, int curSecond, int curWeek) {
        return (long)curYearMonth * 1000000L + (long)(curDay * 10000) + (long)(curHour * 100) + (long)(curMinute / 5);
    }

    @Override
    protected long calcLastTimeNextTime() {
        long yearMonthDayHour = this.lastTime / 100L;
        long curMinuteMod = this.lastTime % 100L;
        if (curMinuteMod < 11L) {
            ++curMinuteMod;
        } else {
            curMinuteMod = 0L;
            yearMonthDayHour = DateTimes.getNextHour(yearMonthDayHour);
        }
        return yearMonthDayHour * 100L + curMinuteMod;
    }

    @Override
    protected final boolean isArrive(int curYearMonth, int curMonthMaxDay, int curDay, int curHour, int curMinute, int curSecond, int curWeek) {
        int curMinuteMod = curMinute % 5;
        if (curMinuteMod < this.taskMinute) {
            return false;
        }
        if (curMinuteMod > this.taskMinute) {
            return true;
        }
        return curSecond >= this.taskSecond;
    }

    public int getTaskMinute() {
        return this.taskMinute;
    }

    public int getTaskSecond() {
        return this.taskSecond;
    }

    @Override
    public String toString() {
        return "{type:Minute5, " + "time:" + this.taskMinute + "/" + this.taskSecond + ", " + "first:" + this.isFirstExecute + "}";
    }
}

