/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.paging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.Lists;

public class PageBuilder {
    public static <T> PageResult<T> newResult(int pageSize) {
        return PageBuilder.newResult(1, pageSize);
    }

    public static <T> PageResult<T> newResult(int pageNo, int pageSize) {
        return new PageResult(0, pageNo, pageSize, new ArrayList(0));
    }

    public static <T> PageResult<T> newResult(int pageSize, T obj) {
        return PageBuilder.newResult(1, pageSize, obj);
    }

    public static <T> PageResult<T> newResult(int pageNo, int pageSize, T obj) {
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(obj);
        return new PageResult(1, pageNo, pageSize, list);
    }

    public static <T> PageResult<T> newResult(int pageSize, T[] objs) {
        return PageBuilder.newResult(1, pageSize, objs);
    }

    public static <T> PageResult<T> newResult(int pageNo, int pageSize, T[] objs) {
        ArrayList<T> list = new ArrayList<T>(objs.length);
        T[] TArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            T obj = TArray[n2];
            list.add(obj);
            ++n2;
        }
        return new PageResult(objs.length, pageNo, pageSize, list);
    }

    public static <T> PageResult<T> newResult(int total, int pageNo, int pageSize, List<T> list) {
        return new PageResult<T>(total, pageNo, pageSize, list);
    }

    public static <T> PageResult<T> newResult(boolean hasNext, int pageNo, int pageSize, List<T> list) {
        return new PageResult<T>(hasNext, pageNo, pageSize, list);
    }

    public static <T> List<T> pageList(int pageNo, int pageSize, List<T> list) {
        if (list == null || list.isEmpty()) {
            return new ArrayList();
        }
        int offset = (pageNo - 1) * pageSize;
        int size = list.size();
        if (size <= offset) {
            return new ArrayList();
        }
        List<T> subList = size <= offset + pageSize ? list.subList(offset, size) : list.subList(offset, offset + pageSize);
        return Lists.trim(subList);
    }

    public static <T> List<T> pageList(int pageNo, int pageSize, Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<T> list = new ArrayList<T>(collection);
        return PageBuilder.pageList(pageNo, pageSize, list);
    }

    public static <T> PageResult<T> pageResult(int pageNo, int pageSize, List<T> list) {
        if (list == null || list.isEmpty()) {
            return PageBuilder.newResult(0, pageNo, pageSize, new ArrayList());
        }
        List<T> subList = PageBuilder.pageList(pageNo, pageSize, list);
        return new PageResult<T>(list.size(), pageNo, pageSize, subList);
    }

    public static <T> PageResult<T> pageResult(int pageNo, int pageSize, Collection<T> collection) {
        if (collection == null || collection.isEmpty()) {
            return PageBuilder.newResult(0, pageNo, pageSize, new ArrayList());
        }
        List<T> subList = PageBuilder.pageList(pageNo, pageSize, collection);
        return new PageResult<T>(collection.size(), pageNo, pageSize, subList);
    }
}

