/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class DistanceEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;
    private DistanceType type;

    public DistanceEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (values.length == 1) {
            if (values[0] instanceof Matrix) {
                Matrix matrix = (Matrix)values[0];
                EuclideanDistance euclideanDistance = new EuclideanDistance();
                return this.distance((DistanceMeasure)euclideanDistance, matrix);
            }
            throw new IOException("distance function operates on either two numeric arrays or a single matrix as parameters.");
        }
        if (values.length == 2) {
            Object first = values[0];
            Object second = values[1];
            if (null == first) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
            }
            if (null == second) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the second value", this.toExpression(this.constructingFactory)));
            }
            if (first instanceof Matrix) {
                Matrix matrix = (Matrix)first;
                DistanceMeasure distanceMeasure = (DistanceMeasure)second;
                return this.distance(distanceMeasure, matrix);
            }
            if (!(first instanceof List)) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
            }
            if (!(second instanceof List)) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
            }
            EuclideanDistance distanceMeasure = new EuclideanDistance();
            return distanceMeasure.compute(((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray(), ((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray());
        }
        if (values.length == 3) {
            Object first = values[0];
            Object second = values[1];
            DistanceMeasure distanceMeasure = (DistanceMeasure)values[2];
            if (null == first) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
            }
            if (null == second) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the second value", this.toExpression(this.constructingFactory)));
            }
            if (!(first instanceof List)) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the first value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
            }
            if (!(second instanceof List)) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a list of numbers", this.toExpression(this.constructingFactory), first.getClass().getSimpleName()));
            }
            return distanceMeasure.compute(((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray(), ((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray());
        }
        throw new IOException("distance function operates on either two numeric arrays or a single matrix as parameters.");
    }

    private Matrix distance(DistanceMeasure distanceMeasure, Matrix matrix) {
        double[][] data = matrix.getData();
        Array2DRowRealMatrix realMatrix = new Array2DRowRealMatrix(data, false);
        realMatrix = (Array2DRowRealMatrix)realMatrix.transpose();
        data = realMatrix.getDataRef();
        double[][] distanceMatrix = new double[data.length][data.length];
        for (int i = 0; i < data.length; ++i) {
            double[] row = data[i];
            for (int j = 0; j < data.length; ++j) {
                double dist;
                double[] row2 = data[j];
                distanceMatrix[i][j] = dist = distanceMeasure.compute(row, row2);
            }
        }
        return new Matrix(distanceMatrix);
    }

    public static enum DistanceType {
        euclidean,
        manhattan,
        canberra,
        earthMovers;

    }
}

