/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.wltea.analyzer.dic.Dictionary;
import org.wltea.analyzer.lucene.IKTokenizer;
import org.wltea.analyzer.lucene.UpdateThread;

public class IKTokenizerFactory
extends TokenizerFactory
implements ResourceLoaderAware,
UpdateThread.UpdateJob {
    private boolean useSmart;
    private ResourceLoader loader;
    private long lastUpdateTime = -1L;
    private String conf = "ik.conf";

    public IKTokenizerFactory(Map<String, String> args) {
        super(args);
        String useSmartArg = args.get("useSmart");
        String confArg = args.get("conf");
        this.setUseSmart(Boolean.parseBoolean(useSmartArg));
        this.setConf(confArg);
    }

    public Tokenizer create(AttributeFactory factory) {
        return new IKTokenizer(factory, this.useSmart());
    }

    public void inform(ResourceLoader resourceLoader) throws IOException {
        System.out.println(String.format("IKTokenizerFactory " + this.hashCode() + " inform conf: %s", this.getConf()));
        this.loader = resourceLoader;
        this.update();
        if (this.getConf() != null && !this.getConf().trim().isEmpty()) {
            UpdateThread.getInstance().register(this);
        }
    }

    @Override
    public void update() throws IOException {
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        Properties p = this.canUpdate();
        if (p != null) {
            List<String> dicPaths = IKTokenizerFactory.SplitFileNames(p.getProperty("files"));
            ArrayList<Reader> inputStreamReaderList = new ArrayList<Reader>();
            for (String path : dicPaths) {
                if (path == null || path.isEmpty()) continue;
                InputStreamReader isr = new InputStreamReader(this.loader.openResource(path), decoder);
                inputStreamReaderList.add(isr);
            }
            if (!inputStreamReaderList.isEmpty()) {
                Dictionary.reloadDic(inputStreamReaderList);
            }
        }
    }

    private Properties canUpdate() {
        try {
            if (this.getConf() == null) {
                return null;
            }
            Properties p = new Properties();
            InputStream confStream = this.loader.openResource(this.getConf());
            p.load(confStream);
            confStream.close();
            String lastupdate = p.getProperty("lastupdate", "0");
            Long t = new Long(lastupdate);
            if (t > this.lastUpdateTime) {
                this.lastUpdateTime = t;
                String paths = p.getProperty("files");
                if (paths == null || paths.trim().isEmpty()) {
                    return null;
                }
                System.out.println("loading " + this.getConf() + " files success.");
                return p;
            }
            this.lastUpdateTime = t;
            return null;
        }
        catch (Exception e) {
            System.err.println("parsing " + this.getConf() + " NullPointerException!!!" + Arrays.toString(e.getStackTrace()));
            return null;
        }
    }

    private static List<String> SplitFileNames(String fileNames) {
        if (fileNames == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        Collections.addAll(result, fileNames.split("[,\\s]+"));
        return result;
    }

    private boolean useSmart() {
        return this.useSmart;
    }

    private void setUseSmart(boolean useSmart) {
        this.useSmart = useSmart;
    }

    private String getConf() {
        return this.conf;
    }

    private void setConf(String conf) {
        this.conf = conf;
    }
}

