/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.core;

import org.wltea.analyzer.core.Lexeme;

class QuickSortSet {
    private Cell head;
    private Cell tail;
    private int size = 0;

    QuickSortSet() {
    }

    void addLexeme(Lexeme lexeme) {
        Cell newCell = new Cell(lexeme);
        if (this.size == 0) {
            this.head = newCell;
            this.tail = newCell;
            ++this.size;
        } else if (this.tail.compareTo(newCell) < 0) {
            this.tail.next = newCell;
            newCell.prev = this.tail;
            this.tail = newCell;
            ++this.size;
        } else if (this.head.compareTo(newCell) > 0) {
            this.head.prev = newCell;
            newCell.next = this.head;
            this.head = newCell;
            ++this.size;
        } else {
            Cell index = this.tail;
            while (index != null && index.compareTo(newCell) > 0) {
                index = index.prev;
            }
            if ((index != null ? index.compareTo(newCell) : 1) < 0) {
                newCell.prev = index;
                newCell.next = index.next;
                index.next.prev = newCell;
                index.next = newCell;
                ++this.size;
            }
        }
    }

    Lexeme peekFirst() {
        if (this.head != null) {
            return this.head.lexeme;
        }
        return null;
    }

    Lexeme pollFirst() {
        if (this.size == 1) {
            Lexeme first = this.head.lexeme;
            this.head = null;
            this.tail = null;
            --this.size;
            return first;
        }
        if (this.size > 1) {
            Lexeme first = this.head.lexeme;
            this.head = this.head.next;
            --this.size;
            return first;
        }
        return null;
    }

    Lexeme peekLast() {
        if (this.tail != null) {
            return this.tail.lexeme;
        }
        return null;
    }

    Lexeme pollLast() {
        if (this.size == 1) {
            Lexeme last = this.head.lexeme;
            this.head = null;
            this.tail = null;
            --this.size;
            return last;
        }
        if (this.size > 1) {
            Lexeme last = this.tail.lexeme;
            this.tail = this.tail.prev;
            --this.size;
            return last;
        }
        return null;
    }

    int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    Cell getHead() {
        return this.head;
    }

    class Cell
    implements Comparable<Cell> {
        private Cell prev;
        private Cell next;
        private Lexeme lexeme;

        Cell(Lexeme lexeme) {
            if (lexeme == null) {
                throw new IllegalArgumentException("lexeme must not be null");
            }
            this.lexeme = lexeme;
        }

        @Override
        public int compareTo(Cell o) {
            return this.lexeme.compareTo(o.lexeme);
        }

        public Cell getPrev() {
            return this.prev;
        }

        Cell getNext() {
            return this.next;
        }

        public Lexeme getLexeme() {
            return this.lexeme;
        }
    }
}

