/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.core;

import java.util.Arrays;
import org.wltea.analyzer.core.AnalyzeContext;
import org.wltea.analyzer.core.ISegmenter;
import org.wltea.analyzer.core.Lexeme;

class LetterSegmenter
implements ISegmenter {
    private static final String SEGMENTER_NAME = "LETTER_SEGMENTER";
    private static final char[] Letter_Connector = new char[]{'#', '&', '+', '-', '.', '@', '_'};
    private static final char[] Num_Connector = new char[]{',', '.'};
    private int start;
    private int end;
    private int englishStart;
    private int englishEnd;
    private int arabicStart;
    private int arabicEnd;

    LetterSegmenter() {
        Arrays.sort(Letter_Connector);
        Arrays.sort(Num_Connector);
        this.start = -1;
        this.end = -1;
        this.englishStart = -1;
        this.englishEnd = -1;
        this.arabicStart = -1;
        this.arabicEnd = -1;
    }

    @Override
    public void analyze(AnalyzeContext context) {
        boolean bufferLockFlag = this.processEnglishLetter(context);
        bufferLockFlag = this.processArabicLetter(context) || bufferLockFlag;
        boolean bl = bufferLockFlag = this.processMixLetter(context) || bufferLockFlag;
        if (bufferLockFlag) {
            context.lockBuffer(SEGMENTER_NAME);
        } else {
            context.unlockBuffer(SEGMENTER_NAME);
        }
    }

    @Override
    public void reset() {
        this.start = -1;
        this.end = -1;
        this.englishStart = -1;
        this.englishEnd = -1;
        this.arabicStart = -1;
        this.arabicEnd = -1;
    }

    private boolean processMixLetter(AnalyzeContext context) {
        Lexeme newLexeme;
        if (this.start == -1) {
            if (1 == context.getCurrentCharType() || 2 == context.getCurrentCharType()) {
                this.end = this.start = context.getCursor();
            }
        } else if (1 == context.getCurrentCharType() || 2 == context.getCurrentCharType()) {
            this.end = context.getCursor();
        } else if (0 == context.getCurrentCharType() && this.isLetterConnector(context.getCurrentChar())) {
            this.end = context.getCursor();
        } else {
            newLexeme = new Lexeme(context.getBufferOffset(), this.start, this.end - this.start + 1, 3);
            context.addLexeme(newLexeme);
            this.start = -1;
            this.end = -1;
        }
        if (context.isBufferConsumed() && this.start != -1 && this.end != -1) {
            newLexeme = new Lexeme(context.getBufferOffset(), this.start, this.end - this.start + 1, 3);
            context.addLexeme(newLexeme);
            this.start = -1;
            this.end = -1;
        }
        boolean needLock = this.start != -1 || this.end != -1;
        return needLock;
    }

    private boolean processEnglishLetter(AnalyzeContext context) {
        Lexeme newLexeme;
        if (this.englishStart == -1) {
            if (2 == context.getCurrentCharType()) {
                this.englishEnd = this.englishStart = context.getCursor();
            }
        } else if (2 == context.getCurrentCharType()) {
            this.englishEnd = context.getCursor();
        } else {
            newLexeme = new Lexeme(context.getBufferOffset(), this.englishStart, this.englishEnd - this.englishStart + 1, 1);
            context.addLexeme(newLexeme);
            this.englishStart = -1;
            this.englishEnd = -1;
        }
        if (context.isBufferConsumed() && this.englishStart != -1 && this.englishEnd != -1) {
            newLexeme = new Lexeme(context.getBufferOffset(), this.englishStart, this.englishEnd - this.englishStart + 1, 1);
            context.addLexeme(newLexeme);
            this.englishStart = -1;
            this.englishEnd = -1;
        }
        boolean needLock = this.englishStart != -1 || this.englishEnd != -1;
        return needLock;
    }

    private boolean processArabicLetter(AnalyzeContext context) {
        Lexeme newLexeme;
        if (this.arabicStart == -1) {
            if (1 == context.getCurrentCharType()) {
                this.arabicEnd = this.arabicStart = context.getCursor();
            }
        } else if (1 == context.getCurrentCharType()) {
            this.arabicEnd = context.getCursor();
        } else {
            newLexeme = new Lexeme(context.getBufferOffset(), this.arabicStart, this.arabicEnd - this.arabicStart + 1, 2);
            context.addLexeme(newLexeme);
            this.arabicStart = -1;
            this.arabicEnd = -1;
        }
        if (context.isBufferConsumed() && this.arabicStart != -1 && this.arabicEnd != -1) {
            newLexeme = new Lexeme(context.getBufferOffset(), this.arabicStart, this.arabicEnd - this.arabicStart + 1, 2);
            context.addLexeme(newLexeme);
            this.arabicStart = -1;
            this.arabicEnd = -1;
        }
        boolean needLock = this.arabicStart != -1 || this.arabicEnd != -1;
        return needLock;
    }

    private boolean isLetterConnector(char input) {
        int index = Arrays.binarySearch(Letter_Connector, input);
        return index >= 0;
    }

    private boolean isNumConnector(char input) {
        int index = Arrays.binarySearch(Num_Connector, input);
        return index >= 0;
    }
}

